/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.EntityLink;
import com.atlassian.applinks.api.EntityType;
import com.atlassian.applinks.api.PropertySet;
import com.atlassian.applinks.api.SubvertedEntityLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.event.EntityLinkAddedEvent;
import com.atlassian.applinks.api.event.EntityLinkDeletedEvent;
import com.atlassian.applinks.core.InternalTypeAccessor;
import com.atlassian.applinks.core.link.DefaultEntityLinkBuilderFactory;
import com.atlassian.applinks.core.link.InternalEntityLinkService;
import com.atlassian.applinks.core.property.EntityLinkProperties;
import com.atlassian.applinks.core.property.PropertyService;
import com.atlassian.applinks.core.rest.client.EntityLinkClient;
import com.atlassian.applinks.host.spi.EntityReference;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.applinks.spi.link.EntityLinkBuilderFactory;
import com.atlassian.applinks.spi.link.ReciprocalActionException;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEntityLinkService
implements InternalEntityLinkService,
SubvertedEntityLinkService {
    private static final Logger LOG = LoggerFactory.getLogger((String)DefaultEntityLinkService.class.getName());
    private static final String LINKED_ENTITIES = "linked.entities";
    private static final String PRIMARY_FMT = "primary.%s";
    private static final String TYPE = "type";
    private static final String TYPE_I18N = "typeI18n";
    private static final String APPLICATION_ID = "applicationId";
    private static final String KEY = "key";
    private static final String NAME = "name";
    private PropertyService propertyService;
    private ApplicationLinkService applicationLinkService;
    private EntityLinkBuilderFactory entityLinkBuilderFactory;
    private InternalHostApplication internalHostApplication;
    private InternalTypeAccessor typeAccessor;
    private EntityLinkClient entityLinkClient;
    private EventPublisher eventPublisher;

    public void setPropertyService(PropertyService propertyService) {
        this.propertyService = propertyService;
    }

    public void setApplicationLinkService(ApplicationLinkService applicationLinkService) {
        this.applicationLinkService = applicationLinkService;
    }

    public void setEntityLinkBuilderFactory(DefaultEntityLinkBuilderFactory entityLinkBuilderFactory) {
        this.entityLinkBuilderFactory = entityLinkBuilderFactory;
    }

    public void setHostApplication(InternalHostApplication internalHostApplication) {
        this.internalHostApplication = internalHostApplication;
    }

    public void setTypeAccessor(InternalTypeAccessor typeAccessor) {
        this.typeAccessor = typeAccessor;
    }

    public void setEntityLinkClient(EntityLinkClient entityLinkClient) {
        this.entityLinkClient = entityLinkClient;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public void setEntityLinkBuilderFactory(EntityLinkBuilderFactory entityLinkBuilderFactory) {
        this.entityLinkBuilderFactory = entityLinkBuilderFactory;
    }

    public EntityLinkBuilderFactory getEntityLinkBuilderFactory() {
        return this.entityLinkBuilderFactory;
    }

    public EntityLink addReciprocatedEntityLink(String localKey, Class<? extends EntityType> localTypeClass, EntityLink entityLink) throws ReciprocalActionException, CredentialsRequiredException {
        this.entityLinkClient.createEntityLinkFrom(entityLink, this.loadTypeFromClass(localTypeClass), localKey);
        return this.addEntityLink(localKey, localTypeClass, entityLink);
    }

    private EntityType loadTypeFromClass(Class<? extends EntityType> localTypeClass) {
        return (EntityType)Preconditions.checkNotNull((Object)this.typeAccessor.getEntityType(localTypeClass), (Object)String.format("%s class available, but type not installed?", localTypeClass));
    }

    @Override
    public void migrateEntityLinks(final ApplicationLink from, final ApplicationLink to) {
        if (LOG.isDebugEnabled()) {
            String message = String.format("Migrating Entity Links from Application Link [%s] to [%s]", from.getId().get(), to.getId().get());
            LOG.debug(message);
        }
        for (final EntityReference localEntity : this.internalHostApplication.getLocalEntities()) {
            ArrayList entityLinks = Lists.newArrayList((Iterable)Iterables.transform(this.getStoredEntityLinks(localEntity.getKey(), localEntity.getType().getClass()), (Function)new Function<EntityLink, EntityLink>(){

                public EntityLink apply(@Nullable EntityLink oldEntityLink) {
                    if (oldEntityLink.getApplicationLink().getId().equals((Object)from.getId())) {
                        EntityLink newEntityLink = DefaultEntityLinkService.this.entityLinkBuilderFactory.builder().applicationLink(to).type(oldEntityLink.getType()).key(oldEntityLink.getKey()).name(oldEntityLink.getName()).primary(oldEntityLink.isPrimary()).build();
                        EntityLinkProperties oldLinkProperties = DefaultEntityLinkService.this.propertyService.getProperties(oldEntityLink);
                        EntityLinkProperties newLinkProperties = DefaultEntityLinkService.this.propertyService.getProperties(newEntityLink);
                        newLinkProperties.setProperties(oldLinkProperties);
                        oldLinkProperties.removeAll();
                        String primaryPropertyKey = DefaultEntityLinkService.primaryPropertyKey(TypeId.getTypeId((EntityType)newEntityLink.getType()));
                        PropertySet props = DefaultEntityLinkService.this.propertyService.getLocalEntityProperties(localEntity.getKey(), TypeId.getTypeId((EntityType)localEntity.getType()));
                        Object value = props.getProperty(primaryPropertyKey);
                        if (value != null) {
                            Properties primary = (Properties)value;
                            if (from.getId().get().equals(primary.get(DefaultEntityLinkService.APPLICATION_ID))) {
                                primary.put(DefaultEntityLinkService.APPLICATION_ID, to.getId().get());
                                props.putProperty(primaryPropertyKey, (Object)primary);
                            }
                        }
                        return newEntityLink;
                    }
                    return oldEntityLink;
                }
            }));
            this.setStoredEntityLinks(localEntity.getKey(), localEntity.getType().getClass(), entityLinks);
        }
    }

    public EntityLink addEntityLink(String localKey, Class<? extends EntityType> localType, EntityLink entityLink) {
        List<EntityLink> entities = this.getStoredEntityLinks(localKey, localType);
        boolean isUpdate = false;
        Iterator<EntityLink> iterator = entities.iterator();
        while (iterator.hasNext()) {
            EntityLink storedEntity = iterator.next();
            if (!DefaultEntityLinkService.equivalent(storedEntity, entityLink)) continue;
            iterator.remove();
            isUpdate = true;
            break;
        }
        if (LOG.isDebugEnabled()) {
            String message = isUpdate ? String.format("Updating Entity Link for [%s] [%s] as [%s]", localType, localKey, entityLink) : String.format("Adding Entity Link for [%s] [%s] as [%s]", localType, localKey, entityLink);
            LOG.debug(message);
        }
        entities.add(entityLink);
        this.setStoredEntityLinks(localKey, localType, entities);
        if (entityLink.isPrimary() || this.getPrimaryRef(localKey, this.lookUpTypeId(localType), TypeId.getTypeId((EntityType)entityLink.getType())) == null) {
            this.makePrimaryImpl(localKey, localType, entityLink);
        }
        this.eventPublisher.publish((Object)new EntityLinkAddedEvent(entityLink, localKey, localType));
        return entityLink;
    }

    private TypeId lookUpTypeId(Class<? extends EntityType> localType) {
        EntityType type = this.typeAccessor.getEntityType(localType);
        if (type == null) {
            throw new IllegalStateException("Couldn't load " + localType.getName() + ", type not installed?");
        }
        return TypeId.getTypeId((EntityType)type);
    }

    public boolean deleteReciprocatedEntityLink(String localKey, Class<? extends EntityType> localType, EntityLink entityToDelete) throws ReciprocalActionException, CredentialsRequiredException {
        if (LOG.isDebugEnabled()) {
            String message = String.format("Deleting Reciprocated Entity Link for [%s] [%s] was [%s]", this.loadTypeFromClass(localType), localKey, entityToDelete);
            LOG.debug(message);
        }
        this.entityLinkClient.deleteEntityLinkFrom(entityToDelete, this.loadTypeFromClass(localType), localKey);
        return this.deleteEntityLink(localKey, localType, entityToDelete);
    }

    public boolean deleteEntityLink(String localKey, Class<? extends EntityType> localType, EntityLink entityToDelete) {
        List<EntityLink> entities = this.getStoredEntityLinks(localKey, localType);
        boolean deleted = false;
        Iterator<EntityLink> iterator = entities.iterator();
        while (iterator.hasNext()) {
            EntityLink entity = iterator.next();
            if (!DefaultEntityLinkService.equivalent(entity, entityToDelete)) continue;
            iterator.remove();
            deleted = true;
            break;
        }
        if (deleted) {
            PrimaryRef primary;
            if (LOG.isDebugEnabled()) {
                String message = String.format("Deleting Entity Link for [%s] [%s] was [%s]", this.loadTypeFromClass(localType), localKey, entityToDelete);
                LOG.debug(message);
            }
            if ((primary = this.getPrimaryRef(localKey, this.lookUpTypeId(localType), TypeId.getTypeId((EntityType)entityToDelete.getType()))).refersTo(entityToDelete)) {
                this.selectNewPrimary(localKey, localType, entityToDelete.getType().getClass(), entities);
            }
            this.propertyService.getProperties(entityToDelete).removeAll();
            this.setStoredEntityLinks(localKey, localType, entities);
            this.eventPublisher.publish((Object)new EntityLinkDeletedEvent(entityToDelete, localKey, localType));
        }
        return deleted;
    }

    private void selectNewPrimary(String localKey, Class<? extends EntityType> localType, Class<? extends EntityType> type, Iterable<? extends EntityLink> entities) {
        Iterator<? extends EntityLink> it = entities.iterator();
        if (!it.hasNext()) {
            String primaryPropertyKey = DefaultEntityLinkService.primaryPropertyKey(this.lookUpTypeId(type));
            this.propertyService.getLocalEntityProperties(localKey, this.lookUpTypeId(localType)).removeProperty(primaryPropertyKey);
        } else {
            this.makePrimaryImpl(localKey, localType, it.next());
        }
    }

    public void deleteEntityLinksFor(final ApplicationLink link) {
        Preconditions.checkNotNull((Object)link);
        if (LOG.isDebugEnabled()) {
            String message = String.format("Deleting Entity Links for Application Link [%s]", link.getId().get());
            LOG.debug(message);
        }
        for (final EntityReference localEntity : this.internalHostApplication.getLocalEntities()) {
            final HashSet typesForWhichToReassignPrimaries = new HashSet();
            final HashSet removedEntityLinks = new HashSet();
            ArrayList updatedLinks = Lists.newArrayList((Iterable)Iterables.filter(this.getStoredEntityLinks(localEntity.getKey(), localEntity.getType().getClass()), (Predicate)new Predicate<EntityLink>(){

                public boolean apply(EntityLink input) {
                    if (link.getId().equals((Object)input.getApplicationLink().getId())) {
                        PrimaryRef primary;
                        if (!typesForWhichToReassignPrimaries.contains(input.getType().getClass()) && (primary = DefaultEntityLinkService.this.getPrimaryRef(localEntity.getKey(), TypeId.getTypeId((EntityType)localEntity.getType()), TypeId.getTypeId((EntityType)input.getType()))).refersTo(input)) {
                            typesForWhichToReassignPrimaries.add(input.getType().getClass());
                        }
                        removedEntityLinks.add(input);
                        return false;
                    }
                    return true;
                }
            }));
            for (Class type : typesForWhichToReassignPrimaries) {
                this.selectNewPrimary(localEntity.getKey(), localEntity.getType().getClass(), type, updatedLinks);
            }
            for (EntityLink removedLink : removedEntityLinks) {
                this.propertyService.getProperties(removedLink).removeAll();
            }
            this.setStoredEntityLinks(localEntity.getKey(), localEntity.getType().getClass(), updatedLinks);
            for (EntityLink removedLink : removedEntityLinks) {
                this.eventPublisher.publish((Object)new EntityLinkDeletedEvent(removedLink, localEntity.getKey(), localEntity.getType().getClass()));
            }
        }
    }

    private List<EntityLink> getStoredEntityLinks(String localKey, Class<? extends EntityType> localType) {
        return this.getStoredEntityLinks(localKey, localType, PermissionMode.CHECK);
    }

    private List<EntityLink> getStoredEntityLinks(String localKey, Class<? extends EntityType> localType, PermissionMode permissionMode) {
        List<String> encodedLinks;
        Preconditions.checkNotNull((Object)localKey);
        Preconditions.checkNotNull(localType);
        switch (permissionMode) {
            case CHECK: {
                if (this.internalHostApplication.doesEntityExist(localKey, localType)) break;
                LOG.error(String.format("No local entity with key '%s' and type '%s' exists", localKey, localType));
                return Lists.newArrayList();
            }
            case NO_CHECK: {
                if (this.internalHostApplication.doesEntityExistNoPermissionCheck(localKey, localType)) break;
                LOG.error(String.format("No local entity with key '%s' and type '%s' exists", localKey, localType));
                return Lists.newArrayList();
            }
            default: {
                LOG.error("Unknown permission mode: " + (Object)((Object)permissionMode));
                return Lists.newArrayList();
            }
        }
        if ((encodedLinks = this.getEncodedLinks(localKey, localType)) == null) {
            encodedLinks = new ArrayList<String>();
        }
        ArrayList<EntityLink> entityLinks = new ArrayList<EntityLink>();
        for (String from : encodedLinks) {
            ApplicationLink applicationLink;
            ApplicationId applicationId;
            JSONObject obj;
            try {
                obj = new JSONObject(from);
                applicationId = new ApplicationId(this.getRequiredJSONString(obj, APPLICATION_ID));
            }
            catch (JSONException e) {
                throw new RuntimeException("Failed to decode stored entity link to JSON for local entity with key '" + localKey + "' and of type '" + localType + "'. Encoded string is: '" + from + "'", e);
            }
            try {
                applicationLink = this.applicationLinkService.getApplicationLink(applicationId);
            }
            catch (TypeNotInstalledException e) {
                LOG.warn(String.format("Couldn't load application link with id %s, type %s is not installed. All child entity links will be inaccessible.", applicationId, e.getType()));
                continue;
            }
            if (applicationLink == null) {
                LOG.debug("Skipping EntityLink [" + from + "] for [" + localKey + "." + this.lookUpTypeId(localType) + "." + LINKED_ENTITIES + "] because ApplicationLink with id [" + applicationId + "] was not found. It should be removed.");
                continue;
            }
            TypeId typeId = new TypeId(this.getRequiredJSONString(obj, TYPE));
            EntityType type = this.typeAccessor.loadEntityType(typeId);
            if (type == null) {
                LOG.warn(String.format("Couldn't load type %s for entity link (child of application link with id %s). Type is not installed? ", typeId, applicationLink.getId()));
                continue;
            }
            String key = this.getRequiredJSONString(obj, KEY);
            PrimaryRef primaryRef = this.getPrimaryRef(localKey, this.lookUpTypeId(localType), TypeId.getTypeId((EntityType)type));
            boolean isPrimary = primaryRef != null ? primaryRef.refersTo(key, TypeId.getTypeId((EntityType)type), applicationLink.getId()) : false;
            entityLinks.add(this.entityLinkBuilderFactory.builder().key(key).type(type).name(this.getRequiredJSONString(obj, NAME)).applicationLink(applicationLink).primary(isPrimary).build());
        }
        return entityLinks;
    }

    private List<String> getEncodedLinks(String localKey, Class<? extends EntityType> localType) {
        return (List)this.propertyService.getLocalEntityProperties(localKey, this.lookUpTypeId(localType)).getProperty(LINKED_ENTITIES);
    }

    private void setStoredEntityLinks(String localKey, Class<? extends EntityType> localType, Iterable<? extends EntityLink> entities) {
        Preconditions.checkNotNull((Object)localKey);
        Preconditions.checkNotNull(localType);
        if (entities == null) {
            if (LOG.isDebugEnabled()) {
                String message = String.format("Removing stored entity links for [%s] [%s] was [%s]", localKey, this.lookUpTypeId(localType), this.propertyService.getLocalEntityProperties(localKey, this.lookUpTypeId(localType)).getProperty(LINKED_ENTITIES));
                LOG.debug(message);
            }
            this.propertyService.getLocalEntityProperties(localKey, this.lookUpTypeId(localType)).removeProperty(LINKED_ENTITIES);
            return;
        }
        ArrayList encodedEntities = Lists.newArrayList((Iterable)Iterables.transform(entities, (Function)new Function<EntityLink, String>(){

            public String apply(EntityLink from) {
                HashMap<String, String> propertyMap = new HashMap<String, String>();
                propertyMap.put(DefaultEntityLinkService.KEY, from.getKey());
                propertyMap.put(DefaultEntityLinkService.NAME, from.getName());
                propertyMap.put(DefaultEntityLinkService.TYPE, TypeId.getTypeId((EntityType)from.getType()).get());
                propertyMap.put(DefaultEntityLinkService.TYPE_I18N, from.getType().getI18nKey());
                propertyMap.put(DefaultEntityLinkService.APPLICATION_ID, from.getApplicationLink().getId().get());
                StringWriter sw = new StringWriter();
                try {
                    new JSONObject(propertyMap).write((Writer)sw);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
                return sw.getBuffer().toString();
            }
        }));
        if (LOG.isDebugEnabled()) {
            String message = String.format("Setting stored entity links for [%s] [%s] as [%s]", localKey, this.lookUpTypeId(localType), entities);
            LOG.debug(message);
        }
        this.propertyService.getLocalEntityProperties(localKey, this.lookUpTypeId(localType)).putProperty(LINKED_ENTITIES, (Object)encodedEntities);
    }

    private String getJSONString(JSONObject obj, String propertyKey) {
        try {
            return obj.isNull(propertyKey) ? null : (String)obj.get(propertyKey);
        }
        catch (JSONException je) {
            throw new RuntimeException(je);
        }
    }

    private String getRequiredJSONString(JSONObject obj, String propertyKey) throws NullPointerException {
        return this.assertNotNull(this.getJSONString(obj, propertyKey), propertyKey);
    }

    private <T> T assertNotNull(T value, String propertyKey) {
        return (T)Preconditions.checkNotNull(value, (Object)(EntityLink.class.getSimpleName() + " property '" + propertyKey + "' should not be null!"));
    }

    private String getRequiredString(Map map, String propertyKey) {
        return this.assertNotNull((String)map.get(propertyKey), propertyKey);
    }

    public Iterable<EntityLink> getEntityLinksForKey(String localKey, Class<? extends EntityType> localType, Class<? extends EntityType> typeOfRemoteEntities) {
        return this.getEntityLinksForKey(localKey, localType, typeOfRemoteEntities, PermissionMode.CHECK);
    }

    private Iterable<EntityLink> getEntityLinksForKey(String localKey, Class<? extends EntityType> localType, final Class<? extends EntityType> typeOfRemoteEntities, PermissionMode permissionMode) {
        Preconditions.checkNotNull((Object)localKey);
        Preconditions.checkNotNull(localType);
        Preconditions.checkNotNull(typeOfRemoteEntities);
        return Iterables.filter(this.getStoredEntityLinks(localKey, localType, permissionMode), (Predicate)new Predicate<EntityLink>(){

            public boolean apply(EntityLink input) {
                return typeOfRemoteEntities.isAssignableFrom(input.getType().getClass());
            }
        });
    }

    public Iterable<EntityLink> getEntityLinks(Object entity, Class<? extends EntityType> type) {
        Preconditions.checkNotNull((Object)entity);
        EntityReference entityRef = this.internalHostApplication.toEntityReference(entity);
        return this.getEntityLinksForKey(entityRef.getKey(), entityRef.getType().getClass(), type);
    }

    public Iterable<EntityLink> getEntityLinksForKey(String localKey, Class<? extends EntityType> localType) {
        return this.getEntityLinksForKey(localKey, localType, PermissionMode.CHECK);
    }

    private Iterable<EntityLink> getEntityLinksForKey(String localKey, Class<? extends EntityType> localType, PermissionMode permissionMode) {
        Preconditions.checkNotNull((Object)localKey);
        Preconditions.checkNotNull(localType);
        return this.getStoredEntityLinks(localKey, localType, permissionMode);
    }

    public Iterable<EntityLink> getEntityLinks(Object domainObject) {
        Preconditions.checkNotNull((Object)domainObject);
        EntityReference entityRef = this.internalHostApplication.toEntityReference(domainObject);
        return this.getEntityLinksForKey(entityRef.getKey(), entityRef.getType().getClass());
    }

    public Iterable<EntityLink> getEntityLinksNoPermissionCheck(Object entity, Class<? extends EntityType> type) {
        Preconditions.checkNotNull((Object)entity);
        EntityReference entityRef = this.internalHostApplication.toEntityReference(entity);
        return this.getEntityLinksForKey(entityRef.getKey(), entityRef.getType().getClass(), type, PermissionMode.NO_CHECK);
    }

    public Iterable<EntityLink> getEntityLinksNoPermissionCheck(Object domainObject) {
        Preconditions.checkNotNull((Object)domainObject);
        EntityReference entityRef = this.internalHostApplication.toEntityReference(domainObject);
        return this.getEntityLinksForKey(entityRef.getKey(), entityRef.getType().getClass(), PermissionMode.NO_CHECK);
    }

    public EntityLink getPrimaryEntityLinkForKey(String localKey, Class<? extends EntityType> localType, Class<? extends EntityType> typeOfRemoteEntity) {
        Preconditions.checkNotNull((Object)localKey);
        Preconditions.checkNotNull(localType);
        Preconditions.checkNotNull(typeOfRemoteEntity);
        EntityLink primary = null;
        PrimaryRef primaryRef = this.getPrimaryRef(localKey, this.lookUpTypeId(localType), this.lookUpTypeId(typeOfRemoteEntity));
        if (primaryRef != null) {
            for (EntityLink entity : this.getEntityLinksForKey(localKey, localType)) {
                if (!primaryRef.refersTo(entity)) continue;
                primary = entity;
                break;
            }
        }
        return primary;
    }

    public EntityLink getPrimaryEntityLink(Object domainObject, Class<? extends EntityType> type) {
        Preconditions.checkNotNull((Object)domainObject);
        EntityReference entityRef = this.internalHostApplication.toEntityReference(domainObject);
        return this.getPrimaryEntityLinkForKey(entityRef.getKey(), entityRef.getType().getClass(), type);
    }

    public EntityLink getEntityLink(String localKey, Class<? extends EntityType> localType, String remoteKey, Class<? extends EntityType> remoteType, ApplicationId applicationId) {
        EntityLink link = null;
        for (EntityLink storedLink : this.getStoredEntityLinks(localKey, localType)) {
            if (!DefaultEntityLinkService.equivalent(storedLink, remoteKey, remoteType, applicationId)) continue;
            link = storedLink;
            break;
        }
        return link;
    }

    public Iterable<EntityLink> getEntityLinksForApplicationLink(final ApplicationLink applicationLink) throws TypeNotInstalledException {
        Preconditions.checkNotNull((Object)applicationLink);
        ArrayList<EntityLink> entityLinks = new ArrayList<EntityLink>();
        for (EntityReference localEntity : this.internalHostApplication.getLocalEntities()) {
            ArrayList list = Lists.newArrayList((Iterable)Iterables.filter(this.getStoredEntityLinks(localEntity.getKey(), localEntity.getType().getClass()), (Predicate)new Predicate<EntityLink>(){

                public boolean apply(EntityLink input) {
                    return applicationLink.getId().equals((Object)input.getApplicationLink().getId());
                }
            }));
            entityLinks.addAll(list);
        }
        return entityLinks;
    }

    public EntityLink makePrimary(String localKey, Class<? extends EntityType> localType, EntityLink newPrimary) {
        Preconditions.checkNotNull((Object)localKey);
        Preconditions.checkNotNull(localType);
        Preconditions.checkNotNull((Object)newPrimary);
        if (this.getEntityLink(localKey, localType, newPrimary.getKey(), newPrimary.getType().getClass(), newPrimary.getApplicationLink().getId()) == null) {
            throw new IllegalArgumentException(String.format("Can not make %s the new primary, not linked to from local entity %s:%s", newPrimary, localType, localKey));
        }
        this.makePrimaryImpl(localKey, localType, newPrimary);
        return newPrimary;
    }

    private static boolean equivalent(EntityLink a, EntityLink b) {
        return DefaultEntityLinkService.equivalent(a, b.getKey(), b.getType().getClass(), b.getApplicationLink().getId());
    }

    private static boolean equivalent(EntityLink a, String key, Class<? extends EntityType> type, ApplicationId applicationId) {
        return a.getKey().equals(key) && a.getType().getClass().equals(type) && a.getApplicationLink().getId().equals((Object)applicationId);
    }

    private void makePrimaryImpl(String localKey, Class<? extends EntityType> localType, EntityLink newEntity) {
        String primaryPropertyKey = DefaultEntityLinkService.primaryPropertyKey(TypeId.getTypeId((EntityType)newEntity.getType()));
        Properties primary = new Properties();
        primary.put(KEY, newEntity.getKey());
        primary.put(APPLICATION_ID, newEntity.getApplicationLink().getId().get());
        if (LOG.isDebugEnabled()) {
            String message = String.format("Set primary link for [%s] [%s] as [%s]", localKey, this.lookUpTypeId(localType), primary);
            LOG.debug(message);
        }
        this.propertyService.getLocalEntityProperties(localKey, this.lookUpTypeId(localType)).putProperty(primaryPropertyKey, (Object)primary);
    }

    private PrimaryRef getPrimaryRef(String key, TypeId typeId, TypeId typeOfRemoteEntity) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)typeId);
        Preconditions.checkNotNull((Object)typeOfRemoteEntity);
        Properties primaryProps = (Properties)this.propertyService.getLocalEntityProperties(key, typeId).getProperty(DefaultEntityLinkService.primaryPropertyKey(typeOfRemoteEntity));
        PrimaryRef primaryRef = null;
        if (primaryProps != null) {
            primaryRef = new PrimaryRef(this.getRequiredString(primaryProps, KEY), typeOfRemoteEntity, new ApplicationId(this.getRequiredString(primaryProps, APPLICATION_ID)));
        }
        return primaryRef;
    }

    private static String primaryPropertyKey(TypeId remoteType) {
        return String.format(PRIMARY_FMT, remoteType.get());
    }

    private static enum PermissionMode {
        CHECK,
        NO_CHECK;

    }

    private static class PrimaryRef {
        private final String key;
        private final TypeId type;
        private final ApplicationId applicationId;

        private PrimaryRef(String key, TypeId type, ApplicationId applicationId) {
            this.key = (String)Preconditions.checkNotNull((Object)key);
            this.type = (TypeId)Preconditions.checkNotNull((Object)type);
            this.applicationId = (ApplicationId)Preconditions.checkNotNull((Object)applicationId);
        }

        public String getKey() {
            return this.key;
        }

        public TypeId getType() {
            return this.type;
        }

        public ApplicationId getApplicationId() {
            return this.applicationId;
        }

        public boolean refersTo(String key, TypeId type, ApplicationId applicationId) {
            return this.key.equals(key) && this.type.equals((Object)type) && this.applicationId.equals((Object)applicationId);
        }

        public boolean refersTo(EntityLink link) {
            return this.refersTo(link.getKey(), TypeId.getTypeId((EntityType)link.getType()), link.getApplicationLink().getId());
        }
    }
}

