/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.event.ApplicationLinkAddedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkDeletedEvent;
import com.atlassian.applinks.api.event.ApplicationLinkMadePrimaryEvent;
import com.atlassian.applinks.core.InternalTypeAccessor;
import com.atlassian.applinks.core.auth.ApplicationLinkRequestFactoryFactory;
import com.atlassian.applinks.core.auth.AuthenticationConfigurator;
import com.atlassian.applinks.core.event.BeforeApplicationLinkDeletedEvent;
import com.atlassian.applinks.core.link.DefaultApplicationLink;
import com.atlassian.applinks.core.link.InternalApplicationLink;
import com.atlassian.applinks.core.link.InternalEntityLinkService;
import com.atlassian.applinks.core.net.BasicHTTPAuthRequestFactory;
import com.atlassian.applinks.core.property.ApplicationLinkProperties;
import com.atlassian.applinks.core.property.PropertyService;
import com.atlassian.applinks.core.rest.client.ApplicationLinkClient;
import com.atlassian.applinks.core.rest.context.CurrentContext;
import com.atlassian.applinks.core.rest.model.ApplicationLinkEntity;
import com.atlassian.applinks.core.rest.model.ErrorListEntity;
import com.atlassian.applinks.core.rest.ui.AuthenticationResource;
import com.atlassian.applinks.core.rest.util.RestUtil;
import com.atlassian.applinks.core.util.URIUtil;
import com.atlassian.applinks.core.v1.rest.ApplicationLinkResource;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.internal.IconUriResolver;
import com.atlassian.applinks.spi.Manifest;
import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationException;
import com.atlassian.applinks.spi.auth.AuthenticationScenario;
import com.atlassian.applinks.spi.link.ApplicationLinkDetails;
import com.atlassian.applinks.spi.link.AuthenticationResponseException;
import com.atlassian.applinks.spi.link.LinkCreationResponseException;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.applinks.spi.link.NotAdministratorException;
import com.atlassian.applinks.spi.link.ReciprocalActionException;
import com.atlassian.applinks.spi.link.RemoteErrorListException;
import com.atlassian.applinks.spi.manifest.ManifestNotFoundException;
import com.atlassian.applinks.spi.manifest.ManifestRetriever;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.NotificationException;
import com.atlassian.plugin.util.ChainingClassLoader;
import com.atlassian.plugin.util.ClassLoaderUtils;
import com.atlassian.plugins.rest.common.Link;
import com.atlassian.plugins.rest.common.util.RestUrlBuilder;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.sun.jersey.api.core.HttpContext;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultApplicationLinkService
implements MutatingApplicationLinkService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultApplicationLinkService.class);
    private static final int CREATE_APPLICATION_LINK_SOCKET_TIMEOUT = 60000;
    private final ApplicationLinkRequestFactoryFactory requestFactoryFactory;
    private final PropertyService propertyService;
    private final InternalEntityLinkService entityLinkService;
    private final InternalTypeAccessor typeAccessor;
    private final ApplicationLinkClient applicationLinkClient;
    private final EventPublisher eventPublisher;
    private final InternalHostApplication internalHostApplication;
    private final RequestFactory<Request<Request<?, com.atlassian.sal.api.net.Response>, com.atlassian.sal.api.net.Response>> requestFactory;
    private final RestUrlBuilder restUrlBuilder;
    private final ManifestRetriever manifestRetriever;
    private final AuthenticationConfigurator authenticationConfigurator;
    static final String APPLICATION_IDS = "application.ids";
    private final Lock applicationIdsLock = new ReentrantLock();

    public DefaultApplicationLinkService(PropertyService propertyService, ApplicationLinkRequestFactoryFactory requestFactoryFactory, InternalEntityLinkService entityLinkService, InternalTypeAccessor typeAccessor, ApplicationLinkClient applicationLinkClient, EventPublisher eventPublisher, InternalHostApplication internalHostApplication, RequestFactory<Request<Request<?, com.atlassian.sal.api.net.Response>, com.atlassian.sal.api.net.Response>> requestFactory, RestUrlBuilder restUrlBuilder, ManifestRetriever manifestRetriever, AuthenticationConfigurator authenticationConfigurator) {
        this.requestFactoryFactory = requestFactoryFactory;
        this.propertyService = propertyService;
        this.entityLinkService = entityLinkService;
        this.typeAccessor = typeAccessor;
        this.applicationLinkClient = applicationLinkClient;
        this.eventPublisher = eventPublisher;
        this.internalHostApplication = internalHostApplication;
        this.requestFactory = requestFactory;
        this.restUrlBuilder = restUrlBuilder;
        this.manifestRetriever = manifestRetriever;
        this.authenticationConfigurator = authenticationConfigurator;
    }

    public InternalApplicationLink getApplicationLink(ApplicationId id) throws TypeNotInstalledException {
        if (!this.getApplicationIds().contains(id)) {
            return null;
        }
        return this.retrieveApplicationLink(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeApplicationId(ApplicationId oldId, ApplicationId newId) throws TypeNotInstalledException {
        this.applicationIdsLock.lock();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Changing application link id from [{}] to [{}]", (Object)oldId, (Object)newId);
        }
        try {
            List<ApplicationId> applicationIds = this.getApplicationIds();
            if (!applicationIds.contains(Preconditions.checkNotNull((Object)oldId))) {
                throw new IllegalArgumentException("Application with server ID " + oldId.toString() + " does not exist.");
            }
            ApplicationLinkProperties oldProperties = this.propertyService.getApplicationLinkProperties(oldId);
            ApplicationLinkProperties newProperties = this.propertyService.getApplicationLinkProperties((ApplicationId)Preconditions.checkNotNull((Object)newId));
            newProperties.setProperties(oldProperties);
            if (!applicationIds.contains(newId)) {
                applicationIds.add(newId);
            } else {
                LOG.warn("There is already an Application Link registered with the ID '" + newId + "'. We are merging the upgraded NON-UAL Application Link with this existing Application Link.");
            }
            this.setApplicationIds(applicationIds);
            InternalApplicationLink from = this.retrieveApplicationLink(oldId);
            InternalApplicationLink to = this.retrieveApplicationLink(newId);
            this.entityLinkService.migrateEntityLinks((ApplicationLink)from, (ApplicationLink)to);
            oldProperties.remove();
            applicationIds.remove(oldId);
            this.setApplicationIds(applicationIds);
        }
        finally {
            this.applicationIdsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makePrimary(ApplicationId id) throws TypeNotInstalledException {
        this.applicationIdsLock.lock();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Making application link id [{}] primary", (Object)id.get());
        }
        try {
            InternalApplicationLink internalApplicationLink = this.getApplicationLink(id);
            Iterable<InternalApplicationLink> applicationLinksOfType = this.getInternalApplicationLinks(internalApplicationLink.getType().getClass());
            for (InternalApplicationLink link : applicationLinksOfType) {
                if (link.getId().equals((Object)id)) {
                    link.setPrimaryFlag(true);
                    continue;
                }
                link.setPrimaryFlag(false);
            }
            this.eventPublisher.publish((Object)new ApplicationLinkMadePrimaryEvent((ApplicationLink)internalApplicationLink));
        }
        finally {
            this.applicationIdsLock.unlock();
        }
    }

    public void setSystem(ApplicationId id, boolean isSystem) throws TypeNotInstalledException {
        InternalApplicationLink internalApplicationLink = this.getApplicationLink(id);
        internalApplicationLink.setSystem(isSystem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalApplicationLink addApplicationLink(ApplicationId id, ApplicationType type, ApplicationLinkDetails details) {
        try {
            List<ApplicationId> applicationIds;
            this.applicationIdsLock.lock();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding application link id [{}]", (Object)id.get());
            }
            if ((applicationIds = this.getApplicationIds()).contains(id)) {
                throw new IllegalArgumentException("Application with server ID " + id + " is already configured");
            }
            boolean onlyLinkOfItsType = Iterables.isEmpty(this.getApplicationLinks(type.getClass()));
            ApplicationLinkProperties applicationLinkProperties = this.propertyService.getApplicationLinkProperties(id);
            applicationLinkProperties.setType(TypeId.getTypeId((ApplicationType)type));
            applicationLinkProperties.setName(this.findSuitableName(details.getName()));
            applicationLinkProperties.setDisplayUrl(details.getDisplayUrl());
            applicationLinkProperties.setRpcUrl(details.getRpcUrl());
            applicationIds.add(id);
            this.setApplicationIds(applicationIds);
            DefaultApplicationLink addedAppLink = new DefaultApplicationLink(id, type, applicationLinkProperties, this.requestFactoryFactory, this.eventPublisher);
            if (details.isPrimary() || onlyLinkOfItsType) {
                try {
                    this.makePrimary(id);
                }
                catch (TypeNotInstalledException e) {
                    LOG.warn("Failed to make new application link the primary application link", (Throwable)e);
                }
            }
            this.eventPublisher.publish((Object)new ApplicationLinkAddedEvent((ApplicationLink)addedAppLink));
            DefaultApplicationLink defaultApplicationLink = addedAppLink;
            return defaultApplicationLink;
        }
        finally {
            this.applicationIdsLock.unlock();
        }
    }

    private String findSuitableName(String name) {
        String proposedName;
        Iterable<ApplicationLink> allApplicationLinks = this.getApplicationLinks();
        if (!this.isNameInUse(name, null, allApplicationLinks)) {
            return name;
        }
        String root = name.replace(" - [0-9]+$", "");
        int i = 2;
        do {
            proposedName = String.format("%s - %d", root, i);
            ++i;
        } while (this.isNameInUse(proposedName, null, allApplicationLinks));
        return proposedName;
    }

    private boolean isNameInUse(final String name, final ApplicationId id, Iterable<? extends ApplicationLink> allApplicationLinks) {
        try {
            Iterables.find(allApplicationLinks, (Predicate)new Predicate<ApplicationLink>(){

                public boolean apply(ApplicationLink appLink) {
                    return appLink.getName().equals(name) && !appLink.getId().equals((Object)id);
                }
            });
        }
        catch (NoSuchElementException nsee) {
            return false;
        }
        return true;
    }

    public boolean isNameInUse(String name, ApplicationId id) {
        Iterable<InternalApplicationLink> allApplicationLinks = this.getInternalApplicationLinks();
        return this.isNameInUse(name, id, allApplicationLinks);
    }

    public void deleteReciprocatedApplicationLink(ApplicationLink link) throws ReciprocalActionException, CredentialsRequiredException {
        this.applicationLinkClient.deleteReciprocalLinkFrom(link);
        this.deleteApplicationLink(link);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteApplicationLink(ApplicationLink link) {
        block12: {
            try {
                this.applicationIdsLock.lock();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Deleting application link id [{}]", (Object)link.getId());
                }
                List<ApplicationId> applicationIds = this.getApplicationIds();
                this.entityLinkService.deleteEntityLinksFor(link);
                if (!applicationIds.remove(link.getId())) break block12;
                ApplicationLinkProperties appLinkProperties = this.propertyService.getApplicationLinkProperties(link.getId());
                TypeId typeId = appLinkProperties.getType();
                boolean wasPrimary = link.isPrimary();
                try {
                    this.eventPublisher.publish((Object)new BeforeApplicationLinkDeletedEvent(link));
                }
                catch (NotificationException e) {
                    LOG.error("An error occurred when broadcasting event {} for application link with id '{}' and name '{}'", new Object[]{BeforeApplicationLinkDeletedEvent.class.getName(), link.getId(), link.getName(), e});
                }
                appLinkProperties.remove();
                this.setApplicationIds(applicationIds);
                if (wasPrimary) {
                    if (typeId == null) {
                        LOG.warn("Failed to make new application link the primary application link to replace link with id '{}' and name '{}': Could not find type", (Object)link.getId(), (Object)link.getName());
                    } else {
                        ApplicationType deletedType = this.typeAccessor.loadApplicationType(typeId);
                        Iterator<InternalApplicationLink> linkIterator = this.getInternalApplicationLinks(deletedType.getClass()).iterator();
                        if (linkIterator.hasNext()) {
                            ApplicationLink newPrimaryApplicationLink = (ApplicationLink)linkIterator.next();
                            try {
                                this.makePrimary(newPrimaryApplicationLink.getId());
                            }
                            catch (TypeNotInstalledException ex) {
                                LOG.warn("Failed to make new application link the primary application link", (Throwable)ex);
                            }
                        }
                    }
                }
                this.eventPublisher.publish((Object)new ApplicationLinkDeletedEvent(link));
            }
            finally {
                this.applicationIdsLock.unlock();
            }
        }
    }

    private InternalApplicationLink retrieveApplicationLink(ApplicationId id) throws TypeNotInstalledException {
        ApplicationLinkProperties properties = this.propertyService.getApplicationLinkProperties((ApplicationId)Preconditions.checkNotNull((Object)id));
        TypeId typeId = properties.getType();
        if (typeId == null) {
            LOG.warn("Couldn't find type id for application link with id {}. Link is corrupted", (Object)id.get());
            throw new TypeNotInstalledException("unknown", properties.getName(), properties.getRpcUrl());
        }
        ApplicationType type = this.typeAccessor.loadApplicationType(typeId);
        if (type == null) {
            LOG.debug("Couldn't load type {} for application link with id {}, name {}, rpc.url {} . The type may not be installed.", new Object[]{typeId, id.get(), properties.getName(), properties.getRpcUrl()});
            throw new TypeNotInstalledException(typeId.get(), properties.getName(), properties.getRpcUrl());
        }
        return new DefaultApplicationLink(id, type, properties, this.requestFactoryFactory, this.eventPublisher);
    }

    public Iterable<ApplicationLink> getApplicationLinks() {
        return Iterables.filter(this.getInternalApplicationLinks(), ApplicationLink.class);
    }

    public Iterable<InternalApplicationLink> getInternalApplicationLinks() {
        ArrayList<InternalApplicationLink> links = new ArrayList<InternalApplicationLink>();
        for (ApplicationId id : this.getApplicationIds()) {
            try {
                links.add(this.retrieveApplicationLink(id));
            }
            catch (TypeNotInstalledException e) {}
        }
        return links;
    }

    public Iterable<ApplicationLink> getApplicationLinks(Class<? extends ApplicationType> type) {
        Iterable internalLinks = Iterables.filter(this.getInternalApplicationLinks(type), ApplicationLink.class);
        ArrayList unsortedLinks = Lists.newArrayList((Iterable)internalLinks);
        Collections.sort(unsortedLinks, new Comparator<ApplicationLink>(){

            @Override
            public int compare(ApplicationLink applicationLink, ApplicationLink applicationLink1) {
                if (applicationLink.isPrimary()) {
                    return -1;
                }
                return 1;
            }
        });
        return unsortedLinks;
    }

    public Iterable<InternalApplicationLink> getInternalApplicationLinks(final Class<? extends ApplicationType> type) {
        Preconditions.checkNotNull(type);
        return Iterables.filter(this.getInternalApplicationLinks(), (Predicate)new Predicate<ApplicationLink>(){

            public boolean apply(ApplicationLink input) {
                return type.isAssignableFrom(input.getType().getClass());
            }
        });
    }

    public ApplicationLink getPrimaryApplicationLink(Class<? extends ApplicationType> type) {
        Iterator<ApplicationLink> iterator = this.getApplicationLinks(type).iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        while (iterator.hasNext()) {
            ApplicationLink application = iterator.next();
            if (!application.isPrimary()) continue;
            return application;
        }
        throw new IllegalStateException("There are application links of type " + type + " configured, but none are " + "marked as primary");
    }

    private List<ApplicationId> getApplicationIds() {
        ArrayList list = (ArrayList)this.propertyService.getGlobalAdminProperties().getProperty(APPLICATION_IDS);
        if (list == null) {
            list = new ArrayList();
        }
        return new ArrayList<ApplicationId>(Lists.transform(list, (Function)new Function<String, ApplicationId>(){

            public ApplicationId apply(String from) {
                return new ApplicationId(from);
            }
        }));
    }

    private void setApplicationIds(List<ApplicationId> applicationIds) {
        if (LOG.isDebugEnabled()) {
            String message = String.format("Setting application link ids [%s]", applicationIds);
            LOG.debug(message);
        }
        this.propertyService.getGlobalAdminProperties().putProperty(APPLICATION_IDS, new ArrayList(Lists.transform(applicationIds, (Function)new Function<ApplicationId, String>(){

            public String apply(ApplicationId from) {
                return from.get();
            }
        })));
    }

    public void createReciprocalLink(URI remoteRpcUrl, URI customLocalRpcUrl, String username, String password) throws ReciprocalActionException {
        ErrorListEntity errorListEntity;
        String url;
        URI localRpcUrl = customLocalRpcUrl != null ? customLocalRpcUrl : this.internalHostApplication.getBaseUrl();
        try {
            boolean adminUser = this.isAdminUserInRemoteApplication(remoteRpcUrl, username, password);
            if (!adminUser) {
                throw new NotAdministratorException();
            }
        }
        catch (ResponseException ex) {
            throw new AuthenticationResponseException();
        }
        ApplicationLinkEntity linkBackToMyself = new ApplicationLinkEntity(this.internalHostApplication.getId(), TypeId.getTypeId((ApplicationType)this.internalHostApplication.getType()), this.internalHostApplication.getName(), this.internalHostApplication.getBaseUrl(), this.internalHostApplication.getType().getIconUrl(), IconUriResolver.resolveIconUri(this.internalHostApplication.getType()), localRpcUrl, false, false, Link.self((URI)this.createSelfLinkFor(this.internalHostApplication.getId())));
        try {
            ApplicationLinkResource resource = (ApplicationLinkResource)this.restUrlBuilder.getUrlFor(RestUtil.getBaseRestUri(remoteRpcUrl), ApplicationLinkResource.class);
            url = resource.updateApplicationLink(this.internalHostApplication.getId().toString(), null).toString();
        }
        catch (TypeNotInstalledException e) {
            throw new AssertionError((Object)(RestUrlBuilder.class.getName() + " must never throw " + TypeNotInstalledException.class.getName()));
        }
        Request<Request<?, com.atlassian.sal.api.net.Response>, com.atlassian.sal.api.net.Response> request = new BasicHTTPAuthRequestFactory(this.requestFactory, username, password).createRequest(Request.MethodType.PUT, url);
        request.setSoTimeout(60000);
        ClassLoader currentContextClassloader = Thread.currentThread().getContextClassLoader();
        ChainingClassLoader chainingClassLoader = new ChainingClassLoader(new ClassLoader[]{currentContextClassloader, ClassLoaderUtils.class.getClassLoader(), ClassLoader.getSystemClassLoader()});
        Thread.currentThread().setContextClassLoader((ClassLoader)chainingClassLoader);
        try {
            errorListEntity = (ErrorListEntity)request.setEntity((Object)linkBackToMyself).executeAndReturn((ReturningResponseHandler)new ReturningResponseHandler<com.atlassian.sal.api.net.Response, ErrorListEntity>(){

                public ErrorListEntity handle(com.atlassian.sal.api.net.Response response) throws ResponseException {
                    return !response.isSuccessful() ? (ErrorListEntity)response.getEntity(ErrorListEntity.class) : null;
                }
            });
        }
        catch (ResponseException ex) {
            String message = "After creating the 2-Way link an error occurred when reading the response from the remote application.";
            LOG.debug("After creating the 2-Way link an error occurred when reading the response from the remote application.", (Throwable)ex);
            throw new LinkCreationResponseException("After creating the 2-Way link an error occurred when reading the response from the remote application.", (Throwable)ex);
        }
        catch (RuntimeException ex) {
            String message = "An error occurred when trying to create the application link in the remote application.";
            LOG.debug("An error occurred when trying to create the application link in the remote application.", (Throwable)ex);
            throw new ReciprocalActionException("An error occurred when trying to create the application link in the remote application.", (Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentContextClassloader);
        }
        if (errorListEntity != null) {
            throw new RemoteErrorListException(errorListEntity.getErrors());
        }
    }

    public boolean isAdminUserInRemoteApplication(URI url, String username, String password) throws ResponseException {
        URI uri = URIUtil.uncheckedConcatenate(url, "/rest/applinks/1.0/");
        AuthenticationResource restUrl = (AuthenticationResource)this.restUrlBuilder.getUrlFor(uri, AuthenticationResource.class);
        return (Boolean)this.requestFactory.createRequest(Request.MethodType.GET, restUrl.getIsAdminUser().toString()).addBasicAuthentication(username, password).executeAndReturn((ReturningResponseHandler)new ReturningResponseHandler<com.atlassian.sal.api.net.Response, Boolean>(){

            public Boolean handle(com.atlassian.sal.api.net.Response restResponse) throws ResponseException {
                return restResponse.isSuccessful();
            }
        });
    }

    public URI createSelfLinkFor(ApplicationId id) {
        try {
            HttpContext context = CurrentContext.getContext();
            URI baseUri = context != null ? context.getUriInfo().getBaseUri() : this.internalHostApplication.getBaseUrl();
            ApplicationLinkResource applicationLinkResource = (ApplicationLinkResource)this.restUrlBuilder.getUrlFor(baseUri, ApplicationLinkResource.class);
            String idString = id.get();
            Response applicationLink = applicationLinkResource.getApplicationLink(idString);
            return this.restUrlBuilder.getURI(applicationLink);
        }
        catch (TypeNotInstalledException e) {
            throw new IllegalStateException(String.format("Failed to load application %s as the %s type is not installed", id.get(), e.getType()));
        }
    }

    public ApplicationLink createApplicationLink(ApplicationType type, ApplicationLinkDetails linkDetails) throws ManifestNotFoundException {
        Manifest manifest = this.manifestRetriever.getManifest(linkDetails.getRpcUrl(), type);
        return this.addApplicationLink(manifest.getId(), type, linkDetails);
    }

    public void configureAuthenticationForApplicationLink(ApplicationLink applicationLink, AuthenticationScenario authenticationScenario, String username, String password) throws AuthenticationConfigurationException {
        this.authenticationConfigurator.configureAuthenticationForApplicationLink(applicationLink, authenticationScenario, new BasicHTTPAuthRequestFactory(this.requestFactory, username, password));
    }
}

