/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.accesslevel.core.retriever;

import com.atlassian.applinks.accesslevel.AuthenticationAwareApplicationLinkResponseHandler;
import com.atlassian.applinks.accesslevel.core.retriever.AuthenticationFailedException;
import com.atlassian.applinks.accesslevel.core.retriever.AuthorizationFailedException;
import com.atlassian.applinks.accesslevel.core.retriever.AuthorizationRequiredException;
import com.atlassian.applinks.accesslevel.core.retriever.BadContentException;
import com.atlassian.applinks.accesslevel.core.retriever.RemoteRequestException;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.AuthorisationURIGenerator;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.auth.Anonymous;
import com.atlassian.applinks.core.auth.oauth.ThreeLeggedOAuthRequest;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RemoteEntityRetriever<T> {
    private static final Logger LOG = LoggerFactory.getLogger((String)RemoteEntityRetriever.class.getName());
    private T content = null;
    private String error = null;
    private Request.MethodType type;
    private String endpoint;
    private ApplicationLink link;
    private boolean requiresAuthentication = false;
    private boolean authenticationFailed = false;
    private boolean authorizationfailed = false;
    private boolean badContent = false;
    private int statusCode = 0;
    private String problem = null;
    private String problemAdvice = null;
    private boolean unrecognizedFailure = false;

    public RemoteEntityRetriever(Request.MethodType type, String endpoint, ApplicationLink link) {
        this.type = type;
        this.endpoint = link.getRpcUrl() + endpoint;
        this.link = link;
    }

    public abstract T process(Response var1) throws Exception;

    public boolean executeAuthenticated() throws AuthorizationFailedException, BadContentException, AuthenticationFailedException, RemoteRequestException {
        return this.execute(this.link.createAuthenticatedRequestFactory());
    }

    public boolean executeAnonymous() throws AuthorizationRequiredException, AuthorizationFailedException, BadContentException, AuthenticationFailedException, RemoteRequestException {
        return this.execute(this.link.createAuthenticatedRequestFactory(Anonymous.class));
    }

    public boolean execute(ApplicationLinkRequestFactory factory) throws AuthorizationFailedException, BadContentException, AuthenticationFailedException, RemoteRequestException {
        Object request = null;
        try {
            LOG.debug("Request '{} {}' via link '{}' using factory '{}'", (Object[])new String[]{this.type.name(), this.endpoint, this.link.getId().get(), factory.toString()});
            request = factory.createRequest(this.type, this.endpoint);
            request.execute((ApplicationLinkResponseHandler)new AuthenticationAwareApplicationLinkResponseHandler<RemoteEntityRetriever>(){

                public RemoteEntityRetriever handle(Response response) {
                    LOG.debug("Response to '{} {}' statusCode '{}' statusText '{}'", (Object[])new String[]{RemoteEntityRetriever.this.type.name(), RemoteEntityRetriever.this.endpoint, "" + response.getStatusCode(), response.getStatusText()});
                    if (LOG.isDebugEnabled()) {
                        for (String headerName : response.getHeaders().keySet()) {
                            LOG.debug("         Header '{} = {}'", (Object[])new String[]{headerName, response.getHeader(headerName)});
                        }
                    }
                    if (response.getStatusCode() == 200) {
                        try {
                            RemoteEntityRetriever.this.success(response);
                        }
                        catch (Exception e) {
                            RemoteEntityRetriever.this.successBadContent(e, response.getStatusCode());
                        }
                    } else if (response.getStatusCode() == 204) {
                        RemoteEntityRetriever.this.successNoContent(response.getStatusCode());
                    } else if (response.getStatusCode() == 401) {
                        JSONObject json = RemoteEntityRetriever.this.getJsonResponse(response);
                        String message = RemoteEntityRetriever.this.getMessage(json);
                        RemoteEntityRetriever.this.authorisationSuccessNoPermissions(response.getStatusCode(), message);
                    } else {
                        RemoteEntityRetriever.this.unsupportedStatusCode(response.getStatusCode());
                    }
                    return RemoteEntityRetriever.this;
                }

                public RemoteEntityRetriever credentialsRequired(Response response) throws ResponseException {
                    RemoteEntityRetriever.this.authorisationRequired(response.getStatusCode(), null, null);
                    return RemoteEntityRetriever.this;
                }

                @Override
                public RemoteEntityRetriever credentialsRequired(Response response, String problem, String problemAdvice) throws ResponseException {
                    RemoteEntityRetriever.this.authorisationRequired(response.getStatusCode(), problem, problemAdvice);
                    return RemoteEntityRetriever.this;
                }

                @Override
                public RemoteEntityRetriever authenticationFailed(Response response, String problem, String problemAdvice) throws ResponseException {
                    RemoteEntityRetriever.this.authenticationFailed(response.getStatusCode(), problem, problemAdvice);
                    return RemoteEntityRetriever.this;
                }
            });
        }
        catch (CredentialsRequiredException e) {
            throw new AuthorizationRequiredException((AuthorisationURIGenerator)factory, ThreeLeggedOAuthRequest.class, "applinks.remote.request.credentials.missing", this.statusCode, this.problem, this.problemAdvice);
        }
        catch (ResponseException e) {
            this.responseError(e);
        }
        if (this.requiresAuthentication) {
            throw new AuthorizationRequiredException((AuthorisationURIGenerator)factory, request.getClass(), "applinks.remote.request.credentials.rejected", this.statusCode, this.problem, this.problemAdvice);
        }
        if (this.authenticationFailed) {
            throw new AuthenticationFailedException((AuthorisationURIGenerator)factory, request.getClass(), "applinks.remote.request.authentication.failed", this.statusCode, this.problem, this.problemAdvice);
        }
        if (this.authorizationfailed) {
            throw new AuthorizationFailedException(request.getClass(), "applinks.remote.request.permission.required", this.statusCode, this.problem, this.problemAdvice);
        }
        if (this.badContent) {
            throw new BadContentException(request.getClass(), "applinks.remote.request.content.bad", this.statusCode);
        }
        if (this.unrecognizedFailure) {
            throw new RemoteRequestException(request.getClass(), "applinks.remote.request.failed", this.statusCode);
        }
        return this.content != null;
    }

    private String getMessage(JSONObject json) {
        try {
            return json != null ? json.getString("message") : null;
        }
        catch (JSONException e) {
            LOG.error("Unable to retrieve message from JSON '{}'", (Object)json, (Object)e);
            return null;
        }
    }

    private JSONObject getJsonResponse(Response response) {
        String body;
        try {
            body = response.getResponseBodyAsString();
        }
        catch (ResponseException e) {
            LOG.error("Unable to extract response body", (Throwable)e);
            return null;
        }
        try {
            return new JSONObject(body);
        }
        catch (JSONException e) {
            LOG.error("Unable to parse response as JSON '{}'", (Object)body, (Object)e);
            return null;
        }
    }

    public ApplicationLink getApplicationLink() {
        return this.link;
    }

    public T getContent() {
        return this.content;
    }

    public void success(Response response) throws Exception {
        LOG.debug("Parse response as Success. Status Code '{}'", (Object)response.getStatusCode());
        T result = this.process(response);
        this.content = result;
    }

    public void successNoContent(int statusCode) {
        LOG.debug("Parse response as Success but no content. Status Code '{}'", (Object)statusCode);
        this.requiresAuthentication = false;
        this.statusCode = statusCode;
    }

    private void authorisationRequired(int statusCode, String problem, String problemAdvice) {
        LOG.debug("Parse response as Failure authentication required. Status Code '{}'. Problem '{}'. Advice '{}'", new Object[]{statusCode, problem, problemAdvice});
        this.requiresAuthentication = true;
        this.problem = problem;
        this.problemAdvice = problemAdvice;
        this.statusCode = statusCode;
    }

    private void authenticationFailed(int statusCode, String problem, String problemAdvice) {
        LOG.debug("Parse response as Failure authentication failed. Status Code '{}'. Problem '{}'. Advice '{}'", new Object[]{statusCode, problem, problemAdvice});
        this.authenticationFailed = true;
        this.problem = problem;
        this.problemAdvice = problemAdvice;
        this.statusCode = statusCode;
    }

    public void authorisationSuccessNoPermissions(int statusCode, String problem) {
        LOG.debug("Parse response as Success but no permissions to access resource. Status Code '{}'. Problem '{}'", (Object)statusCode, (Object)problem);
        this.error = "User does not have permissions to see remote config";
        this.requiresAuthentication = false;
        this.authorizationfailed = true;
        this.statusCode = statusCode;
        this.problem = problem;
    }

    public void unsupportedStatusCode(int statusCode) {
        LOG.debug("Parse response as Failure unsupported status code. Status Code '{}'", (Object)statusCode);
        this.error = "Error hitting endpoint. Code: " + statusCode;
        this.unrecognizedFailure = true;
        this.statusCode = statusCode;
    }

    public void successBadContent(Exception e, int statusCode) {
        LOG.debug("Parse response as Success but with bad content. Status Code '{}'.", (Object)statusCode, (Object)e);
        this.error = "Error processing result: " + e.getMessage();
        this.requiresAuthentication = false;
        e.printStackTrace();
        this.badContent = true;
        this.statusCode = statusCode;
    }

    public void responseError(ResponseException e) {
        LOG.debug("Failure invalid response.", (Throwable)e);
        this.error = "Error with response: " + e.getMessage();
        this.requiresAuthentication = false;
        e.printStackTrace();
    }

    public String getEndpoint() {
        return this.endpoint;
    }
}

