/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.accesslevel.core.rest.model;

import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldErrorsCollection
extends HashMap<String, List<String>> {
    private static final Logger LOG = LoggerFactory.getLogger(FieldErrorsCollection.class);
    private I18nResolver i18nResolver;

    public FieldErrorsCollection(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public FieldErrorsCollection() {
    }

    public void addFieldError(String fieldName, String message) {
        if (this.containsKey(fieldName)) {
            ((List)this.get(fieldName)).add(message);
        } else {
            this.put(fieldName, Lists.newArrayList((Object[])new String[]{message}));
        }
    }

    public void addFieldErrorAsI18nKey(String fieldName, String messageI18nKey) {
        String message;
        if (this.i18nResolver != null) {
            message = this.i18nResolver.getText(messageI18nKey);
        } else {
            LOG.warn("No I18NResolver is available. Passing on i18n key '{}' in place of text.", (Object)messageI18nKey);
            message = messageI18nKey;
        }
        this.addFieldError(fieldName, message);
    }

    public void concatenateFieldErrors(Map<String, List<String>> newFieldErrorsMap) {
        if (newFieldErrorsMap == null) {
            return;
        }
        for (String fieldName : newFieldErrorsMap.keySet()) {
            this.concatenateFieldErrors(fieldName, newFieldErrorsMap.get(fieldName));
        }
    }

    private void concatenateFieldErrors(String fieldName, List<String> messages) {
        if (messages == null) {
            return;
        }
        for (String message : messages) {
            this.addFieldError(fieldName, message);
        }
    }
}

