/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.accesslevel.core.rest.model;

import com.atlassian.applinks.accesslevel.AccessLevel;
import com.atlassian.applinks.accesslevel.core.rest.model.AccessLevelEntity;
import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.core.rest.model.ApplicationLinkEntity;
import com.atlassian.applinks.internal.IconUriResolver;
import com.atlassian.applinks.spi.application.IdentifiableType;
import com.atlassian.applinks.spi.application.TypeId;
import com.atlassian.fugue.Pair;
import com.atlassian.plugins.rest.common.Link;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonAutoDetect;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;

@XmlRootElement(name="accessLevelApplicationLink")
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY, getterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
@JsonIgnoreProperties(ignoreUnknown=true)
public class AccessLevelApplicationLinkEntity
extends ApplicationLinkEntity {
    @XmlElement(name="accessLevels")
    private Map<String, Map<String, AccessLevelEntity>> accessLevels = Maps.newHashMap();

    public AccessLevelApplicationLinkEntity() {
    }

    public AccessLevelApplicationLinkEntity(Link ... links) {
        super(links);
    }

    public AccessLevelApplicationLinkEntity(ApplicationLink applicationLink, Link self) {
        super(applicationLink, self);
    }

    @VisibleForTesting
    public AccessLevelApplicationLinkEntity(ApplicationLink applicationLink, Pair<AccessLevel, Iterable<String>> incoming, Pair<AccessLevel, Iterable<String>> outgoing, Pair<AccessLevel, Iterable<String>> outgoingOperating, Link self) {
        this(applicationLink.getId(), ((IdentifiableType)applicationLink.getType()).getId(), applicationLink.getName(), applicationLink.getDisplayUrl(), applicationLink.getType().getIconUrl(), IconUriResolver.resolveIconUri(applicationLink.getType()), applicationLink.getRpcUrl(), (Boolean)applicationLink.isPrimary(), (Boolean)applicationLink.isSystem(), new AccessLevelEntity(incoming), new AccessLevelEntity(outgoing), new AccessLevelEntity(outgoingOperating), self);
    }

    public AccessLevelApplicationLinkEntity(ApplicationId id, TypeId typeId, String name, URI displayUrl, URI iconUrl, URI iconUri, URI rpcUrl, Boolean primary, Boolean isSystem, AccessLevelEntity incoming, AccessLevelEntity outgoing, AccessLevelEntity outgoingOperating, Link self) {
        super(id, typeId, name, displayUrl, iconUrl, iconUri, rpcUrl, primary, isSystem, self);
        HashMap incomingMap = Maps.newHashMap();
        incomingMap.put("configured", incoming);
        HashMap outgoingMap = Maps.newHashMap();
        outgoingMap.put("configured", outgoing);
        outgoingMap.put("operating", outgoingOperating);
        this.accessLevels = Maps.newHashMap();
        this.accessLevels.put("incoming", incomingMap);
        this.accessLevels.put("outgoing", outgoingMap);
    }

    public AccessLevelApplicationLinkEntity(ApplicationId id, TypeId typeId, String name, URI displayUrl, URI iconUrl, URI iconUri, URI rpcUrl, Boolean isPrimary, Boolean isSystem, Pair<AccessLevel, Iterable<String>> incoming, Pair<AccessLevel, Iterable<String>> outgoing, Pair<AccessLevel, Iterable<String>> outgoingOperating, Link self) {
        this(id, typeId, name, displayUrl, iconUrl, iconUri, rpcUrl, isPrimary, isSystem, new AccessLevelEntity(incoming), new AccessLevelEntity(outgoing), new AccessLevelEntity(outgoingOperating), self);
    }

    public Map<String, Map<String, AccessLevelEntity>> getAccessLevels() {
        return this.accessLevels;
    }

    public AccessLevel getConfiguredAccessLevel(String directionName) {
        if (this.getAccessLevels() == null) {
            return null;
        }
        if (this.getAccessLevels().get(directionName) == null) {
            return null;
        }
        if (this.getAccessLevels().get(directionName).get("configured") == null) {
            return null;
        }
        return this.getAccessLevels().get(directionName).get("configured").getAccessLevel();
    }
}

