/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.accesslevel.core.rest;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.applinks.accesslevel.AccessLevel;
import com.atlassian.applinks.accesslevel.AccessLevelAwareApplicationLinkService;
import com.atlassian.applinks.accesslevel.core.rest.model.AccessLevelApplicationLinkEntity;
import com.atlassian.applinks.accesslevel.core.rest.model.AccessLevelApplicationLinkUIEntity;
import com.atlassian.applinks.accesslevel.core.rest.model.ApplicationLinkEditErrorEntity;
import com.atlassian.applinks.accesslevel.core.rest.model.FieldErrorsCollection;
import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.core.rest.auth.AdminApplicationLinksInterceptor;
import com.atlassian.applinks.core.rest.context.ContextInterceptor;
import com.atlassian.applinks.core.rest.util.RestUtil;
import com.atlassian.applinks.internal.rest.interceptor.V3UiInterceptor;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.plugins.rest.common.Link;
import com.atlassian.plugins.rest.common.interceptor.InterceptorChain;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="config/local")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@ExperimentalApi
@InterceptorChain(value={ContextInterceptor.class, V3UiInterceptor.class})
public class ApplicationLinkResourceLocal {
    private static final Logger LOG = LoggerFactory.getLogger((String)ApplicationLinkResourceLocal.class.getName());
    private final MutatingApplicationLinkService mutatingApplicationLinkService;
    private I18nResolver i18nResolver;
    private final AccessLevelAwareApplicationLinkService accessLevelAwareApplicationLinkService;
    private UserManager userManager;

    public ApplicationLinkResourceLocal(MutatingApplicationLinkService mutatingApplicationLinkService, I18nResolver i18nResolver, AccessLevelAwareApplicationLinkService accessLevelAwareApplicationLinkService, UserManager userManager) {
        this.mutatingApplicationLinkService = mutatingApplicationLinkService;
        this.i18nResolver = i18nResolver;
        this.accessLevelAwareApplicationLinkService = accessLevelAwareApplicationLinkService;
        this.userManager = userManager;
    }

    @GET
    @InterceptorChain(value={AdminApplicationLinksInterceptor.class})
    public Response get() {
        try {
            return RestUtil.ok(this.createResponseEntities());
        }
        catch (TypeNotInstalledException tniex) {
            return this.createErrorResponse(Lists.newArrayList((Object[])new String[]{this.i18nResolver.getText(tniex.getMessageKey(), new Serializable[]{tniex.getType()})}));
        }
        catch (ResponseException e) {
            return this.createErrorResponse(Lists.newArrayList((Object[])new String[]{this.i18nResolver.getText("applinks.error.responseException")}));
        }
    }

    @GET
    @Path(value="{id}")
    @AnonymousAllowed
    public Response get(@PathParam(value="id") String id) {
        ApplicationId applicationId = new ApplicationId(id);
        try {
            return this.createOKResponse(applicationId);
        }
        catch (TypeNotInstalledException tniex) {
            return this.createErrorResponse(Lists.newArrayList((Object[])new String[]{this.i18nResolver.getText(tniex.getMessageKey(), new Serializable[]{tniex.getType()})}));
        }
    }

    @PUT
    @Path(value="{id}")
    @InterceptorChain(value={AdminApplicationLinksInterceptor.class})
    public Response update(@PathParam(value="id") String id, AccessLevelApplicationLinkEntity bean) {
        FieldErrorsCollection fieldErrors = new FieldErrorsCollection(this.i18nResolver);
        fieldErrors.concatenateFieldErrors(this.checkForValidationErrors(bean));
        fieldErrors.concatenateFieldErrors(this.checkForDuplicationErrors(bean));
        if (!fieldErrors.isEmpty()) {
            return this.createErrorResponse(fieldErrors);
        }
        AccessLevel levelIn = bean.getConfiguredAccessLevel("incoming");
        AccessLevel levelOut = bean.getConfiguredAccessLevel("outgoing");
        ApplicationId applicationId = new ApplicationId(id);
        if (!this.accessLevelAwareApplicationLinkService.applicationLinkIsEditable(id)) {
            return this.createErrorResponse(Lists.newArrayList((Object[])new String[]{this.i18nResolver.getText("applinks.accesslevel.linknoteditable")}));
        }
        if ((AccessLevel.PREAUTH.equals((Object)levelOut) || AccessLevel.PREAUTH.equals((Object)levelIn)) && !this.isRemoteUserSysAdmin()) {
            return this.createErrorResponse(401, Lists.newArrayList((Object[])new String[]{this.i18nResolver.getText("applinks.accesslevel.usernotsysadmin")}));
        }
        try {
            this.accessLevelAwareApplicationLinkService.setDetails(applicationId, bean.getName(), bean.getDisplayUrl(), bean.getRpcUrl(), bean.isPrimary());
            if (levelIn != null) {
                this.accessLevelAwareApplicationLinkService.setIncomingAccessLevel(applicationId, levelIn);
            }
            if (levelOut != null) {
                this.accessLevelAwareApplicationLinkService.setOutgoingAccessLevel(applicationId, levelOut);
            }
            return this.createOKResponse(applicationId);
        }
        catch (TypeNotInstalledException tniex) {
            return this.createErrorResponse(Lists.newArrayList((Object[])new String[]{this.i18nResolver.getText(tniex.getMessageKey(), new Serializable[]{tniex.getType()})}));
        }
        catch (ResponseException rex) {
            return this.createErrorResponse(Lists.newArrayList((Object[])new String[]{this.i18nResolver.getText("applinks.error.responseException")}));
        }
    }

    @POST
    @InterceptorChain(value={AdminApplicationLinksInterceptor.class})
    public Response create(AccessLevelApplicationLinkEntity bean) {
        FieldErrorsCollection applinksEditErrors = new FieldErrorsCollection(this.i18nResolver);
        applinksEditErrors.concatenateFieldErrors(this.checkForValidationErrors(bean));
        applinksEditErrors.concatenateFieldErrors(this.checkForDuplicationErrors(bean));
        if (!applinksEditErrors.isEmpty()) {
            return this.createErrorResponse(applinksEditErrors);
        }
        try {
            ApplicationId applicationId = this.accessLevelAwareApplicationLinkService.create(bean.getRpcUrl());
            return this.createOKResponse(applicationId);
        }
        catch (TypeNotInstalledException tniex) {
            return this.createErrorResponse(Lists.newArrayList((Object[])new String[]{this.i18nResolver.getText(tniex.getMessageKey(), new Serializable[]{tniex.getType()})}));
        }
        catch (ResponseException rex) {
            return this.createErrorResponse(Lists.newArrayList((Object[])new String[]{this.i18nResolver.getText("applinks.error.responseException")}));
        }
    }

    @DELETE
    @Path(value="{id}")
    @InterceptorChain(value={AdminApplicationLinksInterceptor.class})
    public Response delete(@PathParam(value="id") String id) {
        if (!this.accessLevelAwareApplicationLinkService.applicationLinkIsEditable(id)) {
            return this.createErrorResponse(Lists.newArrayList((Object[])new String[]{this.i18nResolver.getText("applinks.accesslevel.linknoteditable")}));
        }
        try {
            this.mutatingApplicationLinkService.deleteApplicationLink((ApplicationLink)this.mutatingApplicationLinkService.getApplicationLink(new ApplicationId(id)));
        }
        catch (TypeNotInstalledException tniex) {
            return this.createErrorResponse(Lists.newArrayList((Object[])new String[]{this.i18nResolver.getText(tniex.getMessageKey(), new Serializable[]{tniex.getType()})}));
        }
        return RestUtil.ok();
    }

    private List<AccessLevelApplicationLinkEntity> createResponseEntities() throws TypeNotInstalledException, ResponseException {
        Iterable links = this.mutatingApplicationLinkService.getApplicationLinks();
        LinkedList<AccessLevelApplicationLinkEntity> entities = new LinkedList<AccessLevelApplicationLinkEntity>();
        for (ApplicationLink applicationLink : links) {
            entities.add(this.createResponseEntity(applicationLink));
        }
        return entities;
    }

    private AccessLevelApplicationLinkUIEntity createResponseEntity(ApplicationLink applicationLink) {
        if (!this.isRemoteUserAdmin()) {
            return new AccessLevelApplicationLinkUIEntity(applicationLink, this.accessLevelAwareApplicationLinkService.getIncomingConfiguredAccessLevel(applicationLink.getId()), this.accessLevelAwareApplicationLinkService.getOutgoingConfiguredAccessLevel(applicationLink.getId()), this.accessLevelAwareApplicationLinkService.getOutgoingOperatingAccessLevel(applicationLink.getId()), this.createSelfLinkFor(applicationLink.getId()), this.i18nResolver);
        }
        return new AccessLevelApplicationLinkUIEntity(applicationLink, this.accessLevelAwareApplicationLinkService.getIncomingConfiguredAccessLevel(applicationLink.getId()), this.accessLevelAwareApplicationLinkService.getOutgoingConfiguredAccessLevel(applicationLink.getId()), this.accessLevelAwareApplicationLinkService.getOutgoingOperatingAccessLevel(applicationLink.getId()), this.createSelfLinkFor(applicationLink.getId()), this.i18nResolver);
    }

    private boolean isRemoteUserSysAdmin() {
        UserKey remoteUserKey = this.userManager.getRemoteUserKey();
        return remoteUserKey != null && this.userManager.isSystemAdmin(remoteUserKey);
    }

    private boolean isRemoteUserAdmin() {
        UserKey remoteUserKey = this.userManager.getRemoteUserKey();
        return remoteUserKey != null && this.userManager.isAdmin(remoteUserKey);
    }

    protected Link createSelfLinkFor(ApplicationId appID) {
        return Link.self((URI)this.mutatingApplicationLinkService.createSelfLinkFor(appID));
    }

    private Response createErrorResponse(List<String> formErrors, FieldErrorsCollection fieldErrors) {
        return Response.status((int)400).entity((Object)new ApplicationLinkEditErrorEntity(400, formErrors, fieldErrors)).build();
    }

    private Response createErrorResponse(int httpStatus, List<String> formErrors) {
        return Response.status((int)httpStatus).entity((Object)new ApplicationLinkEditErrorEntity(httpStatus, formErrors)).build();
    }

    private Response createErrorResponse(List<String> formErrors) {
        return Response.status((int)400).entity((Object)new ApplicationLinkEditErrorEntity(400, formErrors)).build();
    }

    private Response createErrorResponse(FieldErrorsCollection fieldErrors) {
        return Response.status((int)400).entity((Object)new ApplicationLinkEditErrorEntity(400, fieldErrors)).build();
    }

    public FieldErrorsCollection checkForValidationErrors(AccessLevelApplicationLinkEntity applicationLinkRequest) {
        FieldErrorsCollection applinksEditErrors = new FieldErrorsCollection(this.i18nResolver);
        this.validateURI(applicationLinkRequest.getRpcUrl(), "rpcUrl", applinksEditErrors);
        this.validateURI(applicationLinkRequest.getDisplayUrl(), "displayUrl", applinksEditErrors);
        this.validateURI(applicationLinkRequest.getIconUrl(), "iconUrl", applinksEditErrors);
        this.validateURI(applicationLinkRequest.getIconUri(), "iconUri", applinksEditErrors);
        if (applicationLinkRequest.getName() != null && applicationLinkRequest.getName().trim().length() <= 0) {
            applinksEditErrors.addFieldErrorAsI18nKey("name", "applinks.error.appname");
        }
        return applinksEditErrors;
    }

    public FieldErrorsCollection checkForDuplicationErrors(AccessLevelApplicationLinkEntity applicationLinkRequest) {
        FieldErrorsCollection applinksEditErrors = new FieldErrorsCollection(this.i18nResolver);
        Iterable<ApplicationLink> otherApplicationLinks = this.getOtherApplicationLinks(applicationLinkRequest);
        this.checkForDuplicateName(applicationLinkRequest, applinksEditErrors, otherApplicationLinks);
        this.checkForDuplicateRpcUrl(applicationLinkRequest, applinksEditErrors, otherApplicationLinks);
        this.checkForDuplicateDisplayUrl(applicationLinkRequest, applinksEditErrors, otherApplicationLinks);
        return applinksEditErrors;
    }

    private Iterable<ApplicationLink> getOtherApplicationLinks(AccessLevelApplicationLinkEntity applicationLinkRequest) {
        Iterable applicationLinks = this.mutatingApplicationLinkService.getApplicationLinks();
        return Iterables.filter((Iterable)applicationLinks, this.getOtherApplicationLinksFilter(applicationLinkRequest));
    }

    private Predicate<ApplicationLink> getOtherApplicationLinksFilter(final AccessLevelApplicationLinkEntity applicationLinkEntityLevels) {
        return new Predicate<ApplicationLink>(){

            public boolean apply(@Nullable ApplicationLink applicationLink) {
                if (applicationLink == null) {
                    return false;
                }
                if (applicationLink.getId() == null && applicationLinkEntityLevels.getId() != null) {
                    return false;
                }
                return !applicationLink.getId().equals((Object)applicationLinkEntityLevels.getId());
            }
        };
    }

    private void checkForDuplicateDisplayUrl(final AccessLevelApplicationLinkEntity applicationLinkEntityLevels, FieldErrorsCollection applinksEditErrors, Iterable<ApplicationLink> applicationLinks) {
        Iterable applicationLinksByDisplayUrl = Iterables.filter(applicationLinks, (Predicate)new Predicate<ApplicationLink>(){

            public boolean apply(@Nullable ApplicationLink applicationLink) {
                if (applicationLink == null) {
                    return false;
                }
                if (applicationLink.getDisplayUrl() == null && applicationLinkEntityLevels.getDisplayUrl() != null) {
                    return false;
                }
                if (applicationLink.getDisplayUrl() == null && applicationLinkEntityLevels.getDisplayUrl() == null) {
                    return true;
                }
                return applicationLink.getDisplayUrl().equals(applicationLinkEntityLevels.getDisplayUrl());
            }
        });
        if (applicationLinksByDisplayUrl.iterator().hasNext()) {
            applinksEditErrors.addFieldErrorAsI18nKey("displayUrl", "applinks.error.displayUrl.duplicate");
        }
    }

    private void checkForDuplicateRpcUrl(final AccessLevelApplicationLinkEntity applicationLinkEntityLevels, FieldErrorsCollection applinksEditErrors, Iterable<ApplicationLink> applicationLinks) {
        Iterable applicationLinksByRpcUrl = Iterables.filter(applicationLinks, (Predicate)new Predicate<ApplicationLink>(){

            public boolean apply(@Nullable ApplicationLink applicationLink) {
                if (applicationLink == null) {
                    return false;
                }
                if (applicationLink.getRpcUrl() == null && applicationLinkEntityLevels.getRpcUrl() != null) {
                    return false;
                }
                return applicationLink.getRpcUrl() == null || applicationLink.getRpcUrl().equals(applicationLinkEntityLevels.getRpcUrl());
            }
        });
        if (applicationLinksByRpcUrl.iterator().hasNext()) {
            applinksEditErrors.addFieldErrorAsI18nKey("rpcUrl", "applinks.error.rpcUrl.duplicate");
        }
    }

    private void checkForDuplicateName(final AccessLevelApplicationLinkEntity applicationLinkEntityLevels, FieldErrorsCollection applinksEditErrors, Iterable<ApplicationLink> otherApplicationLinks) {
        Iterable applicationLinksByName = Iterables.filter(otherApplicationLinks, (Predicate)new Predicate<ApplicationLink>(){

            public boolean apply(@Nullable ApplicationLink applicationLink) {
                if (applicationLink == null) {
                    return false;
                }
                if (applicationLink.getName() == null && applicationLinkEntityLevels.getName() != null) {
                    return false;
                }
                return applicationLink.getName().equals(applicationLinkEntityLevels.getName());
            }
        });
        if (applicationLinksByName.iterator().hasNext()) {
            applinksEditErrors.addFieldErrorAsI18nKey("name", "applinks.error.name.duplicate");
        }
    }

    private void validateURI(URI displayUrl, String fieldName, FieldErrorsCollection applinksEditErrors) {
        if (displayUrl != null) {
            try {
                displayUrl.toURL();
            }
            catch (MalformedURLException e) {
                applinksEditErrors.addFieldErrorAsI18nKey(fieldName, "applinks.error.url.malformed");
            }
            catch (IllegalArgumentException e) {
                applinksEditErrors.addFieldErrorAsI18nKey(fieldName, "applinks.error.url.unknown");
            }
        }
    }

    private Response createOKResponse(ApplicationId applicationId) throws TypeNotInstalledException {
        return RestUtil.ok(this.createResponseEntity((ApplicationLink)this.mutatingApplicationLinkService.getApplicationLink(applicationId)));
    }
}

