/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.accesslevel.core.auth.cors;

import com.atlassian.applinks.accesslevel.AccessLevel;
import com.atlassian.applinks.accesslevel.core.auth.AuthenticationAccessLevelService;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.auth.types.CorsAuthenticationProvider;
import com.atlassian.applinks.core.rest.model.ApplicationLinkAuthenticationEntity;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.fugue.Pair;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.common.collect.Lists;

public class CorsAccessLevelService
implements AuthenticationAccessLevelService {
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final I18nResolver i18nResolver;

    public CorsAccessLevelService(AuthenticationConfigurationManager authenticationConfigurationManager, I18nResolver i18nResolver) {
        this.authenticationConfigurationManager = authenticationConfigurationManager;
        this.i18nResolver = i18nResolver;
    }

    @Override
    public Pair<AccessLevel, Iterable<String>> getIncomingConfiguredAccessLevel(ApplicationLink applicationLink) {
        return new Pair((Object)AccessLevel.ANONYMOUS, (Object)Lists.newArrayList((Object[])new String[]{this.i18nResolver.getText("applinks.accesslevel.incoming.cors.unknown")}));
    }

    @Override
    public void setIncomingConfiguredAccessLevel(ApplicationLink applicationLink, AccessLevel accessLevel) {
    }

    @Override
    public Pair<AccessLevel, Iterable<String>> getOutgoingConfiguredAccessLevel(ApplicationLink applicationLink) {
        return this.authenticationConfigurationManager.isConfigured(applicationLink.getId(), CorsAuthenticationProvider.class) ? new Pair((Object)AccessLevel.UNSUPPORTED, (Object)Lists.newArrayList((Object[])new String[]{this.i18nResolver.getText("applinks.accesslevel.outgoing.cors.configured")})) : new Pair((Object)AccessLevel.ANONYMOUS, (Object)Lists.newArrayList((Object[])new String[]{this.i18nResolver.getText("applinks.accesslevel.outgoing.cors.notconfigured")}));
    }

    @Override
    public void setOutgoingConfiguredAccessLevel(ApplicationLink applicationLink, AccessLevel accessLevel) {
    }

    @Override
    public Pair<AccessLevel, Iterable<String>> getRemoteInstanceOutgoingAccessLevel(ApplicationLinkAuthenticationEntity applicationLinkAuthenticationEntity) {
        return new Pair((Object)AccessLevel.UNKNOWN, (Object)Lists.newArrayList((Object[])new String[]{this.i18nResolver.getText("applinks.accesslevel.remote.outgoing.cors.unknown")}));
    }

    @Override
    public Pair<AccessLevel, Iterable<String>> getRemoteInstanceIncomingAccessLevel(ApplicationLinkAuthenticationEntity applicationLinkAuthenticationEntity) {
        return new Pair((Object)AccessLevel.UNKNOWN, (Object)Lists.newArrayList((Object[])new String[]{this.i18nResolver.getText("applinks.accesslevel.remote.incoming.cors.unknown")}));
    }
}

