/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.accesslevel;

import com.atlassian.applinks.accesslevel.AccessLevel;
import com.atlassian.applinks.accesslevel.AccessLevelAwareApplicationLinkService;
import com.atlassian.applinks.accesslevel.core.auth.AuthenticationAccessLevelService;
import com.atlassian.applinks.accesslevel.core.auth.AuthenticationAccessLevelServiceManager;
import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.application.generic.GenericApplicationType;
import com.atlassian.applinks.application.generic.GenericApplicationTypeImpl;
import com.atlassian.applinks.core.InternalTypeAccessor;
import com.atlassian.applinks.core.auth.AuthenticatorAccessor;
import com.atlassian.applinks.core.rest.model.ApplicationLinkAuthenticationEntity;
import com.atlassian.applinks.spi.Manifest;
import com.atlassian.applinks.spi.application.ApplicationIdUtil;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.applinks.spi.link.ApplicationLinkDetails;
import com.atlassian.applinks.spi.link.MutableApplicationLink;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.applinks.spi.manifest.ManifestNotFoundException;
import com.atlassian.applinks.spi.manifest.ManifestRetriever;
import com.atlassian.fugue.Pair;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAccessLevelAwareApplicationLinkService
implements AccessLevelAwareApplicationLinkService {
    private static final Logger LOG = LoggerFactory.getLogger((String)DefaultAccessLevelAwareApplicationLinkService.class.getName());
    private AuthenticatorAccessor authenticatorAccessor;
    private final ManifestRetriever manifestRetriever;
    private AuthenticationAccessLevelServiceManager authenticationAccessLevelServiceManager;
    private final InternalTypeAccessor typeAccessor;
    private final MutatingApplicationLinkService mutatingApplicationLinkService;
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private I18nResolver i18nResolver;

    public DefaultAccessLevelAwareApplicationLinkService(MutatingApplicationLinkService mutatingApplicationLinkService, AuthenticatorAccessor authenticatorAccessor, ManifestRetriever manifestRetriever, AuthenticationAccessLevelServiceManager authenticationAccessLevelServiceManager, InternalTypeAccessor typeAccessor, AuthenticationConfigurationManager authenticationConfigurationManager, I18nResolver i18nResolver) {
        this.authenticatorAccessor = authenticatorAccessor;
        this.manifestRetriever = manifestRetriever;
        this.authenticationAccessLevelServiceManager = authenticationAccessLevelServiceManager;
        this.typeAccessor = typeAccessor;
        this.mutatingApplicationLinkService = mutatingApplicationLinkService;
        this.authenticationConfigurationManager = authenticationConfigurationManager;
        this.i18nResolver = i18nResolver;
    }

    @Override
    public Pair<AccessLevel, Iterable<String>> getIncomingConfiguredAccessLevel(ApplicationId applicationId) {
        MutableApplicationLink applicationLink = this.getApplicationLink(applicationId);
        Iterable accessLevelPairs = Iterables.transform(this.authenticationAccessLevelServiceManager.getAuthenticationAccessLevelServices(), (Function)new Function<AuthenticationAccessLevelService, Pair<AccessLevel, Iterable<String>>>((ApplicationLink)applicationLink){
            final /* synthetic */ ApplicationLink val$applicationLink;
            {
                this.val$applicationLink = applicationLink;
            }

            public Pair<AccessLevel, Iterable<String>> apply(@Nullable AuthenticationAccessLevelService input) {
                return input == null ? null : input.getIncomingConfiguredAccessLevel(this.val$applicationLink);
            }
        });
        Iterable accessLevels = Iterables.transform((Iterable)accessLevelPairs, (Function)new Function<Pair<AccessLevel, Iterable<String>>, AccessLevel>(){

            public AccessLevel apply(@Nullable Pair<AccessLevel, Iterable<String>> input) {
                return input != null ? (AccessLevel)((Object)input.left()) : null;
            }
        });
        ArrayList accessLevelList = Lists.newArrayList((Iterable)accessLevels);
        accessLevelList.removeAll(Collections.singleton(null));
        Collections.sort(accessLevelList);
        return this.getAccessLevelForLink(accessLevelPairs, accessLevelList);
    }

    @Override
    public Pair<AccessLevel, Iterable<String>> getOutgoingConfiguredAccessLevel(ApplicationId applicationId) {
        MutableApplicationLink applicationLink = this.getApplicationLink(applicationId);
        Iterable accessLevelPairs = Iterables.transform(this.authenticationAccessLevelServiceManager.getAuthenticationAccessLevelServices(), (Function)new Function<AuthenticationAccessLevelService, Pair<AccessLevel, Iterable<String>>>((ApplicationLink)applicationLink){
            final /* synthetic */ ApplicationLink val$applicationLink;
            {
                this.val$applicationLink = applicationLink;
            }

            public Pair<AccessLevel, Iterable<String>> apply(@Nullable AuthenticationAccessLevelService input) {
                return input == null ? null : input.getOutgoingConfiguredAccessLevel(this.val$applicationLink);
            }
        });
        Iterable accessLevels = Iterables.transform((Iterable)accessLevelPairs, (Function)new Function<Pair<AccessLevel, Iterable<String>>, AccessLevel>(){

            public AccessLevel apply(@Nullable Pair<AccessLevel, Iterable<String>> input) {
                return input != null ? (AccessLevel)((Object)input.left()) : null;
            }
        });
        ArrayList accessLevelList = Lists.newArrayList((Iterable)accessLevels);
        accessLevelList.removeAll(Collections.singleton(null));
        Collections.sort(accessLevelList);
        return this.getAccessLevelForLink(accessLevelPairs, accessLevelList);
    }

    @Override
    public Pair<AccessLevel, Iterable<String>> getOutgoingOperatingAccessLevel(ApplicationId applicationId) {
        return new Pair((Object)AccessLevel.UNKNOWN, (Object)Lists.newArrayList((Object[])new String[]{"applinks.accesslevel.outgoing.operating.notyetimplemented"}));
    }

    @Override
    public boolean applicationLinkIsEditable(String id) {
        try {
            MutableApplicationLink link = this.mutatingApplicationLinkService.getApplicationLink(new ApplicationId(id));
            return !link.isSystem();
        }
        catch (TypeNotInstalledException e) {
            LOG.error(String.format("Unable to load application link '%s'", id), (Throwable)e);
            return false;
        }
    }

    @Override
    public void setIncomingAccessLevel(ApplicationId applicationId, AccessLevel accessLevel) throws TypeNotInstalledException, ResponseException {
        if (accessLevel == AccessLevel.UNSUPPORTED || accessLevel == AccessLevel.UNKNOWN) {
            return;
        }
        MutableApplicationLink link = this.getApplicationLink(applicationId);
        if (GenericApplicationTypeImpl.class.isAssignableFrom(link.getType().getClass())) {
            return;
        }
        for (AuthenticationAccessLevelService authenticationAccessLevelService : this.authenticationAccessLevelServiceManager.getAuthenticationAccessLevelServices()) {
            authenticationAccessLevelService.setIncomingConfiguredAccessLevel((ApplicationLink)link, accessLevel);
        }
    }

    @Override
    public void setOutgoingAccessLevel(ApplicationId applicationId, AccessLevel accessLevel) throws TypeNotInstalledException, ResponseException {
        if (accessLevel == AccessLevel.UNSUPPORTED || accessLevel == AccessLevel.UNKNOWN) {
            return;
        }
        MutableApplicationLink link = this.getApplicationLink(applicationId);
        if (GenericApplicationTypeImpl.class.isAssignableFrom(link.getType().getClass())) {
            return;
        }
        for (AuthenticationAccessLevelService authenticationAccessLevelService : this.authenticationAccessLevelServiceManager.getAuthenticationAccessLevelServices()) {
            authenticationAccessLevelService.setOutgoingConfiguredAccessLevel((ApplicationLink)link, accessLevel);
        }
    }

    @Override
    public Pair<AccessLevel, Iterable<String>> getRemoteInstanceOutgoingAccessLevel(final ApplicationLinkAuthenticationEntity applicationLinkAuthenticationEntity) {
        Iterable accessLevelPairs = Iterables.transform(this.authenticationAccessLevelServiceManager.getAuthenticationAccessLevelServices(), (Function)new Function<AuthenticationAccessLevelService, Pair<AccessLevel, Iterable<String>>>(){

            public Pair<AccessLevel, Iterable<String>> apply(@Nullable AuthenticationAccessLevelService input) {
                return input == null ? null : input.getRemoteInstanceOutgoingAccessLevel(applicationLinkAuthenticationEntity);
            }
        });
        Iterable accessLevels = Iterables.transform((Iterable)accessLevelPairs, (Function)new Function<Pair<AccessLevel, Iterable<String>>, AccessLevel>(){

            public AccessLevel apply(@Nullable Pair<AccessLevel, Iterable<String>> input) {
                return input != null ? (AccessLevel)((Object)input.left()) : null;
            }
        });
        ArrayList accessLevelList = Lists.newArrayList((Iterable)accessLevels);
        accessLevelList.removeAll(Collections.singleton(null));
        Collections.sort(accessLevelList);
        return this.getAccessLevelForLink(accessLevelPairs, accessLevelList);
    }

    @Override
    public Pair<AccessLevel, Iterable<String>> getRemoteInstanceIncomingAccessLevel(final ApplicationLinkAuthenticationEntity applicationLinkAuthenticationEntity) {
        Iterable accessLevelPairs = Iterables.transform(this.authenticationAccessLevelServiceManager.getAuthenticationAccessLevelServices(), (Function)new Function<AuthenticationAccessLevelService, Pair<AccessLevel, Iterable<String>>>(){

            public Pair<AccessLevel, Iterable<String>> apply(@Nullable AuthenticationAccessLevelService input) {
                return input == null ? null : input.getRemoteInstanceIncomingAccessLevel(applicationLinkAuthenticationEntity);
            }
        });
        Iterable accessLevels = Iterables.transform((Iterable)accessLevelPairs, (Function)new Function<Pair<AccessLevel, Iterable<String>>, AccessLevel>(){

            public AccessLevel apply(@Nullable Pair<AccessLevel, Iterable<String>> input) {
                return input != null ? (AccessLevel)((Object)input.left()) : null;
            }
        });
        ArrayList accessLevelList = Lists.newArrayList((Iterable)accessLevels);
        accessLevelList.removeAll(Collections.singleton(null));
        Collections.sort(accessLevelList);
        return this.getAccessLevelForLink(accessLevelPairs, accessLevelList);
    }

    @Override
    public void setDetails(ApplicationId linkID, String name, URI uri, URI rpcUrl, Boolean isPrimary) throws TypeNotInstalledException, ResponseException {
        MutableApplicationLink link = this.getApplicationLink(linkID);
        ApplicationLinkDetails.Builder builder = ApplicationLinkDetails.builder();
        builder.name(name != null ? name : link.getName());
        builder.displayUrl(uri != null ? uri : link.getDisplayUrl());
        builder.rpcUrl(rpcUrl != null ? rpcUrl : link.getRpcUrl());
        if (isPrimary.booleanValue()) {
            this.mutatingApplicationLinkService.makePrimary(linkID);
        }
        link.update(builder.build());
    }

    @Override
    public ApplicationLinkDetails getDetails(ApplicationId linkID) throws TypeNotInstalledException, ResponseException {
        MutableApplicationLink link = this.getApplicationLink(linkID);
        ApplicationLinkDetails.Builder builder = ApplicationLinkDetails.builder();
        builder.name(link.getName());
        builder.displayUrl(link.getDisplayUrl());
        builder.rpcUrl(link.getRpcUrl());
        builder.isPrimary(link.isPrimary());
        return builder.build();
    }

    @Override
    public ApplicationId create(URI remoteUri) throws TypeNotInstalledException, ResponseException {
        ApplicationLink applicationLink;
        Manifest manifest;
        try {
            manifest = this.manifestRetriever.getManifest(remoteUri);
        }
        catch (ManifestNotFoundException e) {
            LOG.debug(String.format("Unable to retrieve manifest from '%s'", remoteUri.toASCIIString()), (Throwable)e);
            manifest = null;
        }
        if (manifest != null) {
            applicationLink = this.addAtlassianApplicationLink(manifest, remoteUri);
            this.setIncomingAccessLevel(applicationLink.getId(), AccessLevel.SERVERAUTH);
            this.setOutgoingAccessLevel(applicationLink.getId(), AccessLevel.SERVERAUTH);
        } else {
            applicationLink = this.addGenericApplicationLink(remoteUri);
        }
        return applicationLink.getId();
    }

    private MutableApplicationLink getApplicationLink(ApplicationId linkID) {
        MutableApplicationLink link;
        try {
            link = this.mutatingApplicationLinkService.getApplicationLink(linkID);
        }
        catch (TypeNotInstalledException e) {
            throw new IllegalArgumentException("Unable to load application link with id of " + linkID, e);
        }
        if (link == null) {
            throw new IllegalArgumentException("No application link with id of " + linkID + " found.");
        }
        return link;
    }

    private ApplicationLink addAtlassianApplicationLink(Manifest manifest, URI overrideRpcUri) {
        ApplicationType type = this.typeAccessor.loadApplicationType(manifest.getTypeId());
        MutableApplicationLink applicationLink = this.mutatingApplicationLinkService.addApplicationLink(manifest.getId(), type, ApplicationLinkDetails.builder().displayUrl(manifest.getUrl()).rpcUrl(overrideRpcUri).name(manifest.getName()).build());
        return applicationLink;
    }

    private ApplicationLink addGenericApplicationLink(URI rpcUri) {
        MutableApplicationLink applicationLink = this.mutatingApplicationLinkService.addApplicationLink(ApplicationIdUtil.generate((URI)rpcUri), this.typeAccessor.loadApplicationType(GenericApplicationType.class.getName()), ApplicationLinkDetails.builder().rpcUrl(rpcUri).name(rpcUri.toASCIIString()).build());
        return applicationLink;
    }

    private Pair<AccessLevel, Iterable<String>> getAccessLevelForLink(Iterable<Pair<AccessLevel, Iterable<String>>> accessLevelPairs, List<AccessLevel> accessLevelList) {
        Iterable unsupportedPairs = Iterables.filter(accessLevelPairs, (Predicate)new Predicate<Pair<AccessLevel, Iterable<String>>>(){

            public boolean apply(@Nullable Pair<AccessLevel, Iterable<String>> input) {
                return input != null ? ((AccessLevel)((Object)input.left())).equals((Object)AccessLevel.UNSUPPORTED) : false;
            }
        });
        if (Iterables.size((Iterable)unsupportedPairs) > 0) {
            return (Pair)Iterables.getFirst((Iterable)unsupportedPairs, (Object)new Pair((Object)AccessLevel.UNKNOWN, (Object)Lists.newArrayList()));
        }
        final AccessLevel maxAccessLevel = (AccessLevel)((Object)Iterables.getLast(accessLevelList));
        Iterable maxPairs = Iterables.filter(accessLevelPairs, (Predicate)new Predicate<Pair<AccessLevel, Iterable<String>>>(){

            public boolean apply(@Nullable Pair<AccessLevel, Iterable<String>> input) {
                return input.left() == maxAccessLevel;
            }
        });
        return (Pair)Iterables.getFirst((Iterable)maxPairs, (Object)new Pair((Object)AccessLevel.UNKNOWN, (Object)"applinks.accesslevel.unabletodetermine"));
    }
}

