/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.ui.velocity;

import com.atlassian.applinks.core.InternalTypeAccessor;
import com.atlassian.applinks.core.docs.DocumentationLinker;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.ui.BatchedJSONi18NBuilderFactory;
import com.atlassian.velocity.htmlsafe.HtmlSafe;

public abstract class AbstractVelocityContext {
    protected final String contextPath;
    protected final InternalHostApplication internalHostApplication;
    protected final BatchedJSONi18NBuilderFactory batchedJSONi18NBuilderFactory;
    protected final InternalTypeAccessor typeAccessor;
    protected final DocumentationLinker documentationLinker;

    protected AbstractVelocityContext(String contextPath, InternalHostApplication internalHostApplication, BatchedJSONi18NBuilderFactory batchedJSONi18NBuilderFactory, InternalTypeAccessor typeAccessor, DocumentationLinker documentationLinker) {
        this.contextPath = contextPath;
        this.internalHostApplication = internalHostApplication;
        this.batchedJSONi18NBuilderFactory = batchedJSONi18NBuilderFactory;
        this.typeAccessor = typeAccessor;
        this.documentationLinker = documentationLinker;
    }

    public DocumentationLinker getDocLinker() {
        return this.documentationLinker;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getBaseUrl() {
        return this.internalHostApplication.getBaseUrl().toString();
    }

    public String getApplicationName() {
        return this.internalHostApplication.getName();
    }

    @HtmlSafe
    public String getApplinksI18n() {
        return this.batchedJSONi18NBuilderFactory.builder().withProperties("applinks").withPluggableApplinksModules().build();
    }

    @HtmlSafe
    public String getApplinksDocs() {
        return this.batchedJSONi18NBuilderFactory.builder().withProperties("applinks.docs").with("applinks.docs.root", this.internalHostApplication.getDocumentationBaseUrl().toASCIIString()).build();
    }

    @HtmlSafe
    public String getAppLinksI18n() {
        return this.batchedJSONi18NBuilderFactory.builder().withProperties("applinks").withPluggableApplinksModules().build();
    }
}

