/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.ui.auth;

import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.ui.auth.ServletSessionHandler;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.auth.Authenticator;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.user.UserManager;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AdminUIAuthenticator {
    public static final String ADMIN_USERNAME = "al_username";
    public static final String ADMIN_PASSWORD = "al_password";
    private static final String ADMIN_SESSION_KEY = "al_auth";
    private static final String ADMIN = "admin";
    private static final String SYSADMIN = "sysadmin";
    private final UserManager userManager;
    private final AuthenticationListener authenticationListener;
    private final InternalHostApplication internalHostApplication;
    private static final Result SUCCESS = new Result(true);

    public AdminUIAuthenticator(UserManager userManager, AuthenticationListener authenticationListener, InternalHostApplication internalHostApplication) {
        this.userManager = userManager;
        this.authenticationListener = authenticationListener;
        this.internalHostApplication = internalHostApplication;
    }

    public boolean checkAdminUIAccessBySessionOrPasswordAndActivateAdminSession(String username, String password, SessionHandler sessionHandler) {
        if (this.isAdminSession(sessionHandler)) {
            return true;
        }
        if (this.checkAdminUIAccessByPasswordOrCurrentUser(username, password)) {
            sessionHandler.set(ADMIN_SESSION_KEY, ADMIN);
            return true;
        }
        return false;
    }

    public boolean checkSysadminUIAccessBySessionOrPasswordAndActivateSysadminSession(String username, String password, SessionHandler sessionHandler) {
        if (this.isSysadminSession(sessionHandler)) {
            return true;
        }
        if (this.checkSysadminUIAccessByPasswordOrCurrentUser(username, password)) {
            sessionHandler.set(ADMIN_SESSION_KEY, SYSADMIN);
            return true;
        }
        return false;
    }

    public boolean checkAdminUIAccessByPasswordOrCurrentUser(String username, String password) {
        if (username != null & password != null) {
            return this.userManager.authenticate(username, password) && this.isAdmin(username);
        }
        return this.isCurrentUserAdmin();
    }

    public boolean checkSysadminUIAccessByPasswordOrCurrentUser(String username, String password) {
        if (username != null & password != null) {
            return this.userManager.authenticate(username, password) && this.isSysadmin(username);
        }
        return this.isCurrentUserSysadmin();
    }

    public boolean checkAdminUIAccessBySessionOrCurrentUser(HttpServletRequest request) {
        String username = this.userManager.getRemoteUsername();
        return this.isAdminSession(request) || this.isAdmin(username);
    }

    public boolean checkSysadminUIAccessBySessionOrCurrentUser(HttpServletRequest request) {
        String username = this.userManager.getRemoteUsername();
        return this.isSysadminSession(request) || this.isSysadmin(username);
    }

    public boolean isCurrentUserAdmin() {
        return this.isAdmin(this.userManager.getRemoteUsername());
    }

    public boolean isCurrentUserSysadmin() {
        return this.isSysadmin(this.userManager.getRemoteUsername());
    }

    public Result logInAsPowerUser(String username, String password, HttpServletRequest request, HttpServletResponse response) {
        if (username != null && password != null && this.userManager.authenticate(username, password)) {
            if (this.isAdmin(username)) {
                if (this.isSysadmin(username)) {
                    request.getSession().setAttribute(ADMIN_SESSION_KEY, (Object)SYSADMIN);
                } else {
                    request.getSession().setAttribute(ADMIN_SESSION_KEY, (Object)ADMIN);
                }
                return this.returnPowerUserLoginSuccess(username, request, response);
            }
            return this.returnNotPowerUser(username);
        }
        return this.returnLoginFailed();
    }

    private Result returnLoginFailed() {
        return new Result(false, new Message(){

            public String getKey() {
                return "applinks.admin.login.auth.failed";
            }

            public Serializable[] getArguments() {
                return new Serializable[0];
            }
        });
    }

    private Result returnNotPowerUser(final String username) {
        return new Result(false, new Message(){

            public String getKey() {
                return "applinks.admin.login.auth.authorization.failed";
            }

            public Serializable[] getArguments() {
                return new Serializable[]{username, AdminUIAuthenticator.this.internalHostApplication.getName()};
            }
        });
    }

    private Result returnPowerUserLoginSuccess(String username, HttpServletRequest request, HttpServletResponse response) {
        Message message = new Message(){

            public String getKey() {
                return "Successfully authenticated";
            }

            public Serializable[] getArguments() {
                return null;
            }
        };
        Authenticator.Result.Success result = new Authenticator.Result.Success(message, this.userManager.resolve(username));
        this.authenticationListener.authenticationSuccess((Authenticator.Result)result, request, response);
        return SUCCESS;
    }

    private boolean isAdmin(String username) {
        return username != null && (this.userManager.isAdmin(username) || this.userManager.isSystemAdmin(username));
    }

    private boolean isSysadmin(String username) {
        return username != null && this.userManager.isSystemAdmin(username);
    }

    private boolean isAdminSession(HttpServletRequest request) {
        return this.isAdminSession(new ServletSessionHandler(request));
    }

    private boolean isAdminSession(SessionHandler sessionHandler) {
        return ADMIN.equals(sessionHandler.get(ADMIN_SESSION_KEY)) || SYSADMIN.equals(sessionHandler.get(ADMIN_SESSION_KEY));
    }

    private boolean isSysadminSession(HttpServletRequest request) {
        return this.isSysadminSession(new ServletSessionHandler(request));
    }

    private boolean isSysadminSession(SessionHandler sessionHandler) {
        return SYSADMIN.equals(sessionHandler.get(ADMIN_SESSION_KEY));
    }

    public static interface SessionHandler {
        public void set(String var1, Object var2);

        public Object get(String var1);
    }

    static class Result {
        private final boolean success;
        private final Message message;

        public Result(boolean success) {
            this(success, null);
        }

        Result(boolean success, Message message) {
            this.success = success;
            this.message = message;
        }

        public boolean success() {
            return this.success;
        }

        public Message getMessage() {
            return this.message;
        }
    }
}

