/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.ui.auth;

import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.core.docs.DocumentationLinker;
import com.atlassian.applinks.core.util.MessageFactory;
import com.atlassian.applinks.core.util.RendererContextBuilder;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.spi.application.IdentifiableType;
import com.atlassian.applinks.ui.AbstractApplinksServlet;
import com.atlassian.applinks.ui.BatchedJSONi18NBuilderFactory;
import com.atlassian.applinks.ui.auth.AdminUIAuthenticator;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class AdminLoginServlet
extends AbstractApplinksServlet {
    private static final String TEMPLATE_PATH = "com/atlassian/applinks/ui/admin_login.vm";
    public static final String ORIGINAL_URL = "originalUrl";
    public static final String FOR_ROLE = "forRole";

    public AdminLoginServlet(MessageFactory messageFactory, TemplateRenderer templateRenderer, WebResourceManager webResourceManager, I18nResolver i18nResolver, AdminUIAuthenticator uiAuthenticator, BatchedJSONi18NBuilderFactory batchedJSONi18NBuilderFactory, DocumentationLinker documentationLinker, LoginUriProvider loginUriProvider, InternalHostApplication internalHostApplication) {
        super(i18nResolver, messageFactory, templateRenderer, webResourceManager, batchedJSONi18NBuilderFactory, documentationLinker, loginUriProvider, internalHostApplication, uiAuthenticator);
    }

    @Override
    protected List<String> getRequiredWebResources() {
        return ImmutableList.of((Object)"com.atlassian.applinks.applinks-plugin:admin-login");
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doView(request, response, new HashMap<String, Object>());
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String password;
        String username = request.getParameter("al_username");
        AdminUIAuthenticator.Result result = this.adminUIAuthenticator.logInAsPowerUser(username, password = request.getParameter("al_password"), request, response);
        if (result.success()) {
            response.sendRedirect(StringUtils.defaultIfEmpty((String)request.getParameter(ORIGINAL_URL), (String)request.getContextPath()));
        } else {
            this.doView(request, response, new RendererContextBuilder().put("error", result.getMessage()).put("username", username).build());
        }
    }

    private void doView(HttpServletRequest request, HttpServletResponse response, Map<String, Object> context) throws ServletException, IOException {
        this.render(TEMPLATE_PATH, new RendererContextBuilder(context).put("req", request).put("applicationName", this.internalHostApplication.getName()).put(ORIGINAL_URL, request.getParameter(ORIGINAL_URL)).put("applicationtype", this.getApplicationTypeId()).put(FOR_ROLE, request.getParameter(FOR_ROLE)).build(), request, response);
    }

    private String getApplicationTypeId() {
        ApplicationType type = this.internalHostApplication.getType();
        if (type instanceof IdentifiableType) {
            return ((IdentifiableType)type).getId().get();
        }
        return "unknown";
    }
}

