/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.ui;

import com.atlassian.applinks.core.docs.DocumentationLinker;
import com.atlassian.applinks.core.util.MessageFactory;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.ui.AbstractAppLinksAdminOnlyServlet;
import com.atlassian.applinks.ui.BatchedJSONi18NBuilderFactory;
import com.atlassian.applinks.ui.auth.AdminUIAuthenticator;
import com.atlassian.applinks.ui.velocity.ListApplicationLinksContext;
import com.atlassian.applinks.ui.velocity.VelocityContextFactory;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ListApplicationLinksServlet
extends AbstractAppLinksAdminOnlyServlet {
    private static final String TEMPLATE_PATH = "com/atlassian/applinks/ui/admin/list_application_links.vm";
    private static final String WEB_RESOURCE_CONTEXT = "applinks.list.application.links";
    private static final String IS_SYSADMIN = "isSysadmin";
    private final VelocityContextFactory velocityContextFactory;
    private final WebSudoManager webSudoManager;
    private final UserManager userManager;

    public ListApplicationLinksServlet(I18nResolver i18nResolver, MessageFactory messageFactory, TemplateRenderer templateRenderer, WebResourceManager webResourceManager, AdminUIAuthenticator adminUIAuthenticator, InternalHostApplication internalHostApplication, BatchedJSONi18NBuilderFactory batchedJSONi18NBuilderFactory, DocumentationLinker documentationLinker, LoginUriProvider loginUriProvider, VelocityContextFactory velocityContextFactory, WebSudoManager webSudoManager, XsrfTokenAccessor xsrfTokenAccessor, XsrfTokenValidator xsrfTokenValidator, UserManager userManager) {
        super(i18nResolver, messageFactory, templateRenderer, webResourceManager, adminUIAuthenticator, batchedJSONi18NBuilderFactory, documentationLinker, loginUriProvider, internalHostApplication, xsrfTokenAccessor, xsrfTokenValidator);
        this.velocityContextFactory = velocityContextFactory;
        this.webSudoManager = webSudoManager;
        this.userManager = userManager;
    }

    @Override
    protected List<String> getRequiredWebResourceContexts() {
        return ImmutableList.of((Object)WEB_RESOURCE_CONTEXT);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.webSudoManager.willExecuteWebSudoRequest(request);
            ListApplicationLinksContext context = this.velocityContextFactory.buildListApplicationLinksContext(request);
            this.render(TEMPLATE_PATH, (Map<String, Object>)ImmutableMap.of((Object)"context", (Object)context), request, response);
        }
        catch (WebSudoSessionException wse) {
            this.webSudoManager.enforceWebSudoProtection(request, response);
        }
    }
}

