/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.v2.rest;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuthWithImpersonationAuthenticationProvider;
import com.atlassian.applinks.application.generic.GenericApplicationTypeImpl;
import com.atlassian.applinks.core.InternalTypeAccessor;
import com.atlassian.applinks.core.auth.oauth.OAuthHelper;
import com.atlassian.applinks.core.auth.oauth.ServiceProviderStoreService;
import com.atlassian.applinks.core.rest.auth.AdminApplicationLinksInterceptor;
import com.atlassian.applinks.core.rest.context.ContextInterceptor;
import com.atlassian.applinks.core.rest.model.ApplicationLinkAuthenticationEntity;
import com.atlassian.applinks.core.rest.model.ApplicationLinkEntity;
import com.atlassian.applinks.core.rest.model.AuthenticationProviderEntity;
import com.atlassian.applinks.core.rest.model.AuthenticationProviderEntityListEntity;
import com.atlassian.applinks.core.rest.model.ConsumerEntity;
import com.atlassian.applinks.core.rest.model.ConsumerEntityListEntity;
import com.atlassian.applinks.core.rest.util.RestUtil;
import com.atlassian.applinks.spi.application.ApplicationIdUtil;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.applinks.spi.auth.AuthenticationProviderPluginModule;
import com.atlassian.applinks.spi.link.ApplicationLinkDetails;
import com.atlassian.applinks.spi.link.MutableApplicationLink;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.applinks.spi.manifest.ManifestNotFoundException;
import com.atlassian.applinks.spi.manifest.ManifestRetriever;
import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.oauth.util.RSAKeys;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugins.rest.common.Link;
import com.atlassian.plugins.rest.common.interceptor.InterceptorChain;
import com.atlassian.plugins.rest.common.util.RestUrlBuilder;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.sun.jersey.spi.resource.Singleton;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@Path(value="applicationlink")
@Consumes(value={"application/xml", "application/json"})
@Produces(value={"application/xml", "application/json"})
@Singleton
@WebSudoRequired
@InterceptorChain(value={ContextInterceptor.class, AdminApplicationLinksInterceptor.class})
public class ApplicationLinkResource
extends com.atlassian.applinks.core.v1.rest.ApplicationLinkResource {
    private final PluginAccessor pluginAccessor;
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final ServiceProviderStoreService serviceProviderStoreService;
    private final ConsumerService consumerService;

    public ApplicationLinkResource(MutatingApplicationLinkService applicationLinkService, I18nResolver i18nResolver, InternalTypeAccessor typeAccessor, ManifestRetriever manifestRetriever, RestUrlBuilder restUrlBuilder, RequestFactory requestFactory, UserManager userManager, PluginAccessor pluginAccessor, AuthenticationConfigurationManager authenticationConfigurationManager, ServiceProviderStoreService serviceProviderStoreService, ConsumerService consumerService) {
        super(applicationLinkService, i18nResolver, typeAccessor, manifestRetriever, restUrlBuilder, requestFactory, userManager);
        this.pluginAccessor = pluginAccessor;
        this.authenticationConfigurationManager = authenticationConfigurationManager;
        this.serviceProviderStoreService = serviceProviderStoreService;
        this.consumerService = consumerService;
    }

    @PUT
    public Response addApplicationLink(ApplicationLinkEntity applicationLink) throws TypeNotInstalledException {
        ApplicationType applicationType = this.typeAccessor.loadApplicationType(applicationLink.getTypeId());
        if (applicationType == null) {
            this.LOG.warn(String.format("Couldn't load type %s for application link. Type is not installed?", applicationLink.getTypeId()));
            throw new TypeNotInstalledException(applicationLink.getTypeId().get(), applicationLink.getName(), applicationLink.getRpcUrl());
        }
        if (!(applicationType instanceof GenericApplicationTypeImpl)) {
            try {
                this.manifestRetriever.getManifest(applicationLink.getRpcUrl(), applicationType);
            }
            catch (ManifestNotFoundException e) {
                return RestUtil.badRequest(this.i18nResolver.getText("applinks.error.url.application.not.reachable", new Serializable[]{applicationLink.getRpcUrl()}));
            }
        }
        ApplicationId applicationId = applicationLink.getId();
        if (applicationType instanceof GenericApplicationTypeImpl || applicationId == null) {
            applicationId = ApplicationIdUtil.generate((URI)applicationLink.getRpcUrl());
        }
        MutableApplicationLink existing = this.applicationLinkService.getApplicationLink(applicationId);
        if (this.applicationLinkService.getApplicationLink(applicationId) != null) {
            return RestUtil.badRequest(this.i18nResolver.getText("applinks.error.duplicate.url", new Serializable[]{applicationLink.getRpcUrl()}));
        }
        this.applicationLinkService.addApplicationLink(applicationId, applicationType, applicationLink.getDetails());
        return RestUtil.created(this.createSelfLinkFor(applicationId));
    }

    @Override
    @POST
    @Path(value="{id}")
    public Response updateApplicationLink(@PathParam(value="id") String id, ApplicationLinkEntity applicationLink) throws TypeNotInstalledException {
        ApplicationType applicationType = this.typeAccessor.loadApplicationType(applicationLink.getTypeId());
        if (applicationType == null) {
            this.LOG.warn(String.format("Couldn't load type %s for application link. Type is not installed?", applicationLink.getTypeId()));
            throw new TypeNotInstalledException(applicationLink.getTypeId().get(), applicationLink.getName(), applicationLink.getRpcUrl());
        }
        ApplicationId applicationId = new ApplicationId(id);
        MutableApplicationLink existing = this.applicationLinkService.getApplicationLink(applicationId);
        if (existing == null) {
            return RestUtil.badRequest(this.i18nResolver.getText("applinks.notfound", new Serializable[]{applicationLink.getName()}));
        }
        if (existing.isSystem() && !this.userManager.isSystemAdmin(this.userManager.getRemoteUsername())) {
            return RestUtil.forbidden(this.i18nResolver.getText("applinks.error.only.sysadmin.operation"));
        }
        ApplicationLinkDetails linkDetails = applicationLink.getDetails();
        if (this.applicationLinkService.isNameInUse(linkDetails.getName(), applicationId)) {
            return RestUtil.badRequest(this.i18nResolver.getText("applinks.error.duplicate.name", new Serializable[]{applicationLink.getName()}));
        }
        if (!existing.getRpcUrl().equals(linkDetails.getRpcUrl())) {
            return RestUtil.badRequest(this.i18nResolver.getText("applinks.error.cannot.update.rpcurl"));
        }
        existing.update(linkDetails);
        return RestUtil.updated(this.createSelfLinkFor(applicationLink.getId()));
    }

    @GET
    @Path(value="{id}/authentication")
    public Response getAuthentication(@PathParam(value="id") String id) throws TypeNotInstalledException, URISyntaxException {
        ApplicationLink applicationLink = this.findApplicationLink(id);
        if (applicationLink == null) {
            return RestUtil.notFound(this.i18nResolver.getText("applinks.notfound", new Serializable[]{id}));
        }
        List<AuthenticationProviderEntity> configuredAuthProviders = this.getConfiguredProviders(applicationLink);
        Iterable<Consumer> consumers = this.findConsumers(applicationLink, configuredAuthProviders);
        ArrayList consumerEntities = Lists.newArrayList();
        for (Consumer consumer : consumers) {
            consumerEntities.add(new ConsumerEntity(Link.self((URI)new URI("applicationlink/" + id + "/authentication/consumer")), consumer));
        }
        return RestUtil.ok(new ApplicationLinkAuthenticationEntity(Link.self((URI)new URI("applicationlink/" + id + "/authentication")), consumerEntities, configuredAuthProviders));
    }

    @GET
    @Path(value="{id}/authentication/provider")
    public Response getAuthenticationProvider(@PathParam(value="id") String id) throws TypeNotInstalledException {
        List<AuthenticationProviderEntity> configuredAuthProviders;
        ApplicationLink applicationLink = this.findApplicationLink(id);
        if (applicationLink == null) {
            return RestUtil.notFound(this.i18nResolver.getText("applinks.notfound", new Serializable[]{id}));
        }
        try {
            configuredAuthProviders = this.getConfiguredProviders(applicationLink);
        }
        catch (URISyntaxException e) {
            return RestUtil.serverError(this.i18nResolver.getText("applinks.authenticationproviders.notfound", new Serializable[]{id}));
        }
        return RestUtil.ok(new AuthenticationProviderEntityListEntity(configuredAuthProviders));
    }

    @GET
    @Path(value="{id}/authentication/provider/{provider}")
    public Response getAuthenticationProvider(@PathParam(value="id") String id, @PathParam(value="provider") String provider) throws TypeNotInstalledException {
        List<AuthenticationProviderEntity> configuredAuthProviders;
        ApplicationLink applicationLink = this.findApplicationLink(id);
        if (applicationLink == null) {
            return RestUtil.notFound(this.i18nResolver.getText("applinks.notfound", new Serializable[]{id}));
        }
        try {
            configuredAuthProviders = this.getConfiguredProviders(applicationLink, this.getProviderPredicate(provider));
        }
        catch (URISyntaxException e) {
            return RestUtil.serverError(this.i18nResolver.getText("applinks.authenticationproviders.notfound", new Serializable[]{id}));
        }
        return RestUtil.ok(new AuthenticationProviderEntityListEntity(configuredAuthProviders));
    }

    @PUT
    @Path(value="{id}/authentication/provider")
    public Response putAuthenticationProvider(@PathParam(value="id") String id, AuthenticationProviderEntity authenticationProviderEntity) throws TypeNotInstalledException, URISyntaxException {
        ApplicationLink applicationLink = this.findApplicationLink(id);
        if (applicationLink == null) {
            return RestUtil.notFound(this.i18nResolver.getText("applinks.notfound", new Serializable[]{id}));
        }
        try {
            Class<?> providerClass = Class.forName(authenticationProviderEntity.getProvider());
            if (TwoLeggedOAuthWithImpersonationAuthenticationProvider.class.equals(providerClass) && !this.userManager.isSystemAdmin(this.userManager.getRemoteUsername())) {
                return RestUtil.badRequest(this.i18nResolver.getText("applinks.authentication.provider.2loi.only.available.to.sysadmin", new Serializable[]{id, authenticationProviderEntity.getProvider()}));
            }
            this.authenticationConfigurationManager.registerProvider(applicationLink.getId(), providerClass, authenticationProviderEntity.getConfig());
            return RestUtil.created(Link.self((URI)new URI("applicationlink/" + id + "/authentication/" + authenticationProviderEntity.getProvider())));
        }
        catch (ClassNotFoundException e) {
            return RestUtil.badRequest(this.i18nResolver.getText("applinks.authentication.provider.type.not.recognized", new Serializable[]{id, authenticationProviderEntity.getProvider()}));
        }
    }

    @GET
    @Path(value="{id}/authentication/consumer")
    public Response getConsumer(@PathParam(value="id") String id) throws TypeNotInstalledException, URISyntaxException {
        ApplicationLink applicationLink = this.findApplicationLink(id);
        if (applicationLink == null) {
            return RestUtil.notFound(this.i18nResolver.getText("applinks.notfound", new Serializable[]{id}));
        }
        List<AuthenticationProviderEntity> configuredAuthProviders = this.getConfiguredProviders(applicationLink);
        Iterable<Consumer> consumers = this.findConsumers(applicationLink, configuredAuthProviders);
        if (!consumers.iterator().hasNext() && applicationLink.getType() instanceof GenericApplicationTypeImpl && configuredAuthProviders.size() == 0) {
            return RestUtil.notFound(this.i18nResolver.getText("applinks.generic.consumer.needs.authenticationprovider", new Serializable[]{id}));
        }
        if (!consumers.iterator().hasNext()) {
            return RestUtil.notFound(this.i18nResolver.getText("applinks.consumer.notfound", new Serializable[]{id}));
        }
        ArrayList consumerEntities = Lists.newArrayList();
        for (Consumer consumer : consumers) {
            consumerEntities.add(new ConsumerEntity(Link.self((URI)new URI("applicationlink/" + id + "/authentication/consumer")), consumer));
        }
        return RestUtil.ok(new ConsumerEntityListEntity(consumerEntities));
    }

    @PUT
    @Path(value="{id}/authentication/consumer")
    public Response putConsumer(@PathParam(value="id") String id, @QueryParam(value="autoConfigure") Boolean autoConfigure, ConsumerEntity consumerEntity) throws TypeNotInstalledException, URISyntaxException {
        ApplicationLink applicationLink = this.findApplicationLink(id);
        if (applicationLink == null) {
            return RestUtil.notFound(this.i18nResolver.getText("applinks.notfound", new Serializable[]{id}));
        }
        if (autoConfigure != null && autoConfigure.booleanValue()) {
            try {
                Consumer consumer = OAuthHelper.fetchConsumerInformation(applicationLink);
                Consumer updatedConsumer = new Consumer.InstanceBuilder(consumer.getKey()).name(consumer.getName()).description(consumer.getDescription()).publicKey(consumer.getPublicKey()).signatureMethod(consumer.getSignatureMethod()).callback(consumer.getCallback()).twoLOAllowed(consumerEntity.isTwoLOAllowed()).executingTwoLOUser(consumerEntity.getExecutingTwoLOUser()).twoLOImpersonationAllowed(consumerEntity.isTwoLOImpersonationAllowed()).build();
                this.serviceProviderStoreService.addConsumer(updatedConsumer, applicationLink);
            }
            catch (ResponseException e) {
                return RestUtil.serverError(this.i18nResolver.getText("applinks.consumer.autoconfigure.consumerInfo.notfound"));
            }
            return RestUtil.created(Link.self((URI)new URI("applicationlink/" + id + "/authentication/consumer")));
        }
        if (applicationLink.getType() instanceof GenericApplicationTypeImpl) {
            List<String> errors = this.validate3rdPartyConsumer(consumerEntity);
            if (errors.size() > 0) {
                return RestUtil.badRequest(errors.toArray(new String[errors.size()]));
            }
            if (consumerEntity.isOutgoing()) {
                this.add3rdPartyOutgoingConsumer(consumerEntity);
            } else {
                try {
                    Consumer consumer = this.createBasicConsumer(consumerEntity, applicationLink);
                    this.serviceProviderStoreService.addConsumer(consumer, applicationLink);
                }
                catch (NoSuchAlgorithmException e) {
                    return RestUtil.badRequest(this.i18nResolver.getText("applinks.invalid.consumer.publickey", new Serializable[]{id}));
                }
                catch (InvalidKeySpecException e) {
                    return RestUtil.badRequest(this.i18nResolver.getText("applinks.invalid.consumer.publickey", new Serializable[]{id}));
                }
            }
        } else {
            List<String> errors = this.validateAtlassianConsumer(consumerEntity);
            if (errors.size() > 0) {
                return RestUtil.badRequest(errors.toArray(new String[errors.size()]));
            }
            try {
                Consumer consumer = this.createBasicConsumer(consumerEntity, applicationLink);
                Consumer updatedConsumer = new Consumer.InstanceBuilder(consumer.getKey()).name(consumer.getName()).description(consumer.getDescription()).publicKey(consumer.getPublicKey()).signatureMethod(consumer.getSignatureMethod()).callback(consumer.getCallback()).twoLOAllowed(consumerEntity.isTwoLOAllowed()).executingTwoLOUser(consumerEntity.getExecutingTwoLOUser()).twoLOImpersonationAllowed(consumerEntity.isTwoLOImpersonationAllowed()).build();
                this.serviceProviderStoreService.addConsumer(updatedConsumer, applicationLink);
            }
            catch (NoSuchAlgorithmException e) {
                return RestUtil.badRequest(this.i18nResolver.getText("applinks.invalid.consumer.publickey", new Serializable[]{id}));
            }
            catch (InvalidKeySpecException e) {
                return RestUtil.badRequest(this.i18nResolver.getText("applinks.invalid.consumer.publickey", new Serializable[]{id}));
            }
        }
        return RestUtil.created(Link.self((URI)new URI("applicationlink/" + id + "/authentication/consumer")));
    }

    private Consumer add3rdPartyOutgoingConsumer(ConsumerEntity consumerEntity) {
        Consumer consumer = Consumer.key((String)consumerEntity.getKey()).name(consumerEntity.getName()).signatureMethod(Consumer.SignatureMethod.HMAC_SHA1).description(consumerEntity.getDescription()).build();
        this.consumerService.add(consumer.getName(), consumer, consumerEntity.getSharedSecret());
        return consumer;
    }

    private Consumer createBasicConsumer(ConsumerEntity consumerEntity, ApplicationLink applicationLink) throws InvalidKeySpecException, NoSuchAlgorithmException {
        return Consumer.key((String)consumerEntity.getKey()).name(consumerEntity.getName()).publicKey(RSAKeys.fromPemEncodingToPublicKey((String)consumerEntity.getPublicKey())).description(consumerEntity.getDescription()).callback(consumerEntity.getCallback()).build();
    }

    private List<String> validate3rdPartyConsumer(ConsumerEntity consumerEntity) {
        ArrayList errors = Lists.newArrayList();
        if (StringUtils.isEmpty((String)consumerEntity.getKey())) {
            errors.add(this.i18nResolver.getText("auth.oauth.config.consumer.serviceprovider.key.is.required"));
        }
        if (consumerEntity.isOutgoing()) {
            if (StringUtils.isEmpty((String)consumerEntity.getName())) {
                errors.add(this.i18nResolver.getText("auth.oauth.config.consumer.serviceprovider.name.is.required"));
            }
            if (StringUtils.isEmpty((String)consumerEntity.getSharedSecret())) {
                errors.add(this.i18nResolver.getText("auth.oauth.config.consumer.serviceprovider.shared.secret.is.required"));
            }
        } else if (StringUtils.isEmpty((String)consumerEntity.getPublicKey())) {
            errors.add(this.i18nResolver.getText("auth.oauth.config.serviceprovider.missing.public.key"));
        }
        return errors;
    }

    private List<String> validateAtlassianConsumer(ConsumerEntity consumerEntity) {
        ArrayList errors = Lists.newArrayList();
        if (StringUtils.isEmpty((String)consumerEntity.getKey())) {
            errors.add(this.i18nResolver.getText("auth.oauth.config.consumer.serviceprovider.key.is.required"));
        }
        if (StringUtils.isEmpty((String)consumerEntity.getName())) {
            errors.add(this.i18nResolver.getText("auth.oauth.config.consumer.serviceprovider.name.is.required"));
        }
        if (StringUtils.isEmpty((String)consumerEntity.getPublicKey())) {
            errors.add(this.i18nResolver.getText("applinks.consumer.publickey.required"));
        }
        return errors;
    }

    private Predicate<AuthenticationProviderPluginModule> getProviderPredicate(final String provider) {
        return new Predicate<AuthenticationProviderPluginModule>(){

            public boolean apply(AuthenticationProviderPluginModule input) {
                return input.getAuthenticationProviderClass().getName().equals(provider);
            }
        };
    }

    private List<AuthenticationProviderEntity> getConfiguredProviders(ApplicationLink applicationLink, Predicate<AuthenticationProviderPluginModule> predicate) throws URISyntaxException {
        return this.getConfiguredProviders(applicationLink, Iterables.filter((Iterable)this.pluginAccessor.getEnabledModulesByClass(AuthenticationProviderPluginModule.class), predicate));
    }

    private List<AuthenticationProviderEntity> getConfiguredProviders(ApplicationLink applicationLink) throws URISyntaxException {
        return this.getConfiguredProviders(applicationLink, this.pluginAccessor.getEnabledModulesByClass(AuthenticationProviderPluginModule.class));
    }

    private List<AuthenticationProviderEntity> getConfiguredProviders(ApplicationLink applicationLink, Iterable<AuthenticationProviderPluginModule> pluginModules) throws URISyntaxException {
        ArrayList<AuthenticationProviderEntity> configuredAuthProviders = new ArrayList<AuthenticationProviderEntity>();
        for (AuthenticationProviderPluginModule authenticationProviderPluginModule : pluginModules) {
            AuthenticationProvider authenticationProvider = authenticationProviderPluginModule.getAuthenticationProvider(applicationLink);
            if (authenticationProvider == null) continue;
            Map config = this.authenticationConfigurationManager.getConfiguration(applicationLink.getId(), authenticationProviderPluginModule.getAuthenticationProviderClass());
            configuredAuthProviders.add(new AuthenticationProviderEntity(Link.self((URI)new URI("applicationlink/" + applicationLink.getId().toString() + "/authentication/provider")), authenticationProviderPluginModule.getClass().getName(), authenticationProviderPluginModule.getAuthenticationProviderClass().getName(), config));
        }
        return configuredAuthProviders;
    }

    private ApplicationLink findApplicationLink(String id) throws TypeNotInstalledException {
        ApplicationId applicationId;
        try {
            applicationId = new ApplicationId(id);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return this.applicationLinkService.getApplicationLink(applicationId);
    }

    private Iterable<Consumer> findConsumers(ApplicationLink applicationLink, List<AuthenticationProviderEntity> configuredAuthProviders) {
        ArrayList consumers = Lists.newArrayList();
        Consumer consumer = this.serviceProviderStoreService.getConsumer(applicationLink);
        if (consumer != null) {
            consumers.add(consumer);
        }
        if (applicationLink.getType() instanceof GenericApplicationTypeImpl) {
            for (AuthenticationProviderEntity entity : configuredAuthProviders) {
                Consumer genericOutGoingConsumer;
                String consumerKey;
                if (!(applicationLink.getType() instanceof GenericApplicationTypeImpl) || StringUtils.isEmpty((String)(consumerKey = entity.getConfig().get("consumerKey.outbound"))) || (genericOutGoingConsumer = this.consumerService.getConsumerByKey(consumerKey)) == null) continue;
                consumers.add(genericOutGoingConsumer);
            }
        }
        return consumers;
    }
}

