/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth.oauth.twolo.impersonation;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuthWithImpersonationAuthenticationProvider;
import com.atlassian.applinks.core.auth.oauth.ServiceProviderStoreService;
import com.atlassian.applinks.core.auth.oauth.twolo.AbstractTwoLeggedOAuthAuthenticatorProviderPluginModule;
import com.atlassian.applinks.core.auth.oauth.twolo.impersonation.TwoLeggedOAuthWithImpersonationRequestFactoryImpl;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.sal.api.net.RequestFactory;

public class TwoLeggedOAuthWithImpersonationAuthenticatorProviderPluginModule
extends AbstractTwoLeggedOAuthAuthenticatorProviderPluginModule {
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final ConsumerService consumerService;
    private final RequestFactory requestFactory;
    private final ServiceProviderStoreService serviceProviderStoreService;

    public TwoLeggedOAuthWithImpersonationAuthenticatorProviderPluginModule(AuthenticationConfigurationManager authenticationConfigurationManager, ConsumerService consumerService, InternalHostApplication hostApplication, RequestFactory requestFactory, ServiceProviderStoreService serviceProviderStoreService) {
        super(hostApplication);
        this.authenticationConfigurationManager = authenticationConfigurationManager;
        this.consumerService = consumerService;
        this.requestFactory = requestFactory;
        this.serviceProviderStoreService = serviceProviderStoreService;
    }

    public AuthenticationProvider getAuthenticationProvider(final ApplicationLink link) {
        TwoLeggedOAuthWithImpersonationAuthenticationProvider provider = null;
        if (this.authenticationConfigurationManager.isConfigured(link.getId(), TwoLeggedOAuthWithImpersonationAuthenticationProvider.class)) {
            provider = new TwoLeggedOAuthWithImpersonationAuthenticationProvider(){

                public ApplicationLinkRequestFactory getRequestFactory(String username) {
                    return new TwoLeggedOAuthWithImpersonationRequestFactoryImpl(link, TwoLeggedOAuthWithImpersonationAuthenticatorProviderPluginModule.this.authenticationConfigurationManager, TwoLeggedOAuthWithImpersonationAuthenticatorProviderPluginModule.this.consumerService, TwoLeggedOAuthWithImpersonationAuthenticatorProviderPluginModule.this.requestFactory, username);
                }
            };
        }
        return provider;
    }

    public boolean incomingEnabled(ApplicationLink applicationLink) {
        Consumer consumer = this.serviceProviderStoreService.getConsumer(applicationLink);
        return consumer != null && consumer.getTwoLOAllowed() && consumer.getTwoLOImpersonationAllowed();
    }

    @Override
    public Class<? extends AuthenticationProvider> getAuthenticationProviderClass() {
        return TwoLeggedOAuthWithImpersonationAuthenticationProvider.class;
    }
}

