/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth.oauth.servlets.serviceprovider;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuthAuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuthWithImpersonationAuthenticationProvider;
import com.atlassian.applinks.core.auth.oauth.servlets.AbstractOAuthConfigServlet;
import com.atlassian.applinks.core.docs.DocumentationLinker;
import com.atlassian.applinks.core.util.MessageFactory;
import com.atlassian.applinks.core.util.URIUtil;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.applinks.ui.AbstractApplinksServlet;
import com.atlassian.applinks.ui.BatchedJSONi18NBuilderFactory;
import com.atlassian.applinks.ui.auth.AdminUIAuthenticator;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.websudo.WebSudoManager;
import com.atlassian.sal.api.websudo.WebSudoSessionException;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigureOutgoingTwoLeggedOAuthReciprocalServlet
extends AbstractOAuthConfigServlet {
    public static final String ENABLE_OUTGOING_2LO_AUTHENTICATION_PARAMETER = "enable-outgoing-2lo";
    public static final String OUTGOING_2LO_SUCCESS_PARAM = "outgoing_2lo_success";
    public static final String CALLBACK_PARAM = "callback";
    private static final Iterable<Class<? extends AuthenticationProvider>> TWO_LEGGED_OAUTH_AUTHENTICATION_PROVIDERS = ImmutableSet.of(TwoLeggedOAuthAuthenticationProvider.class, TwoLeggedOAuthWithImpersonationAuthenticationProvider.class);
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final WebSudoManager webSudoManager;
    private static final Logger LOG = LoggerFactory.getLogger(ConfigureOutgoingTwoLeggedOAuthReciprocalServlet.class);

    protected ConfigureOutgoingTwoLeggedOAuthReciprocalServlet(I18nResolver i18nResolver, MessageFactory messageFactory, TemplateRenderer templateRenderer, WebResourceManager webResourceManager, ApplicationLinkService applicationLinkService, AdminUIAuthenticator adminUIAuthenticator, BatchedJSONi18NBuilderFactory batchedJSONi18NBuilderFactory, DocumentationLinker documentationLinker, LoginUriProvider loginUriProvider, InternalHostApplication internalHostApplication, XsrfTokenAccessor xsrfTokenAccessor, XsrfTokenValidator xsrfTokenValidator, AuthenticationConfigurationManager authenticationConfigurationManager, WebSudoManager webSudoManager) {
        super(i18nResolver, messageFactory, templateRenderer, webResourceManager, applicationLinkService, adminUIAuthenticator, batchedJSONi18NBuilderFactory, documentationLinker, loginUriProvider, internalHostApplication, xsrfTokenAccessor, xsrfTokenValidator);
        this.authenticationConfigurationManager = authenticationConfigurationManager;
        this.webSudoManager = webSudoManager;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse resp) throws ServletException, IOException {
        block9: {
            try {
                ApplicationLink applicationLink;
                this.webSudoManager.willExecuteWebSudoRequest(request);
                try {
                    applicationLink = this.getRequiredApplicationLink(request);
                }
                catch (AbstractApplinksServlet.NotFoundException ex) {
                    resp.sendRedirect(this.createRedirectUrl(request, true, null));
                    return;
                }
                boolean enable = Boolean.parseBoolean(request.getParameter(ENABLE_OUTGOING_2LO_AUTHENTICATION_PARAMETER));
                try {
                    if (enable) {
                        for (Class<? extends AuthenticationProvider> authenticationProvider : TWO_LEGGED_OAUTH_AUTHENTICATION_PROVIDERS) {
                            this.authenticationConfigurationManager.registerProvider(applicationLink.getId(), authenticationProvider, Collections.emptyMap());
                        }
                        resp.sendRedirect(this.createRedirectUrl(request, true, this.i18nResolver.getText("auth.oauth.config.serviceprovider.outgoing.2lo.enabled")));
                        break block9;
                    }
                    for (Class<? extends AuthenticationProvider> authenticationProvider : TWO_LEGGED_OAUTH_AUTHENTICATION_PROVIDERS) {
                        this.authenticationConfigurationManager.unregisterProvider(applicationLink.getId(), authenticationProvider);
                    }
                    resp.sendRedirect(this.createRedirectUrl(request, true, this.i18nResolver.getText("auth.oauth.config.serviceprovider.outgoing.2lo.disabled")));
                }
                catch (Exception e) {
                    LOG.error("Error occurred when trying to " + (enable ? "enable" : "disable") + " outgoing 2-Legged OAuth authentication configuration for application link '" + applicationLink + "'", (Throwable)e);
                    String message = enable ? this.i18nResolver.getText("auth.oauth.config.error.reciprocal.outgoing.2lo.config.enable") : this.i18nResolver.getText("auth.oauth.config.error.reciprocal.outgoing.2lo.config.disable");
                    resp.sendRedirect(this.createRedirectUrl(request, false, message));
                }
            }
            catch (WebSudoSessionException wse) {
                this.webSudoManager.enforceWebSudoProtection(request, resp);
            }
        }
    }

    public static String getReciprocalServletUrl(URI baseUrl, ApplicationId applicationId, String callbackUrl, String actionParamValue) {
        URI enableOAuthURL = URIUtil.uncheckedConcatenate(baseUrl, "/plugins/servlet/applinks/auth/conf/oauth/outbound/apl-2lo/" + applicationId + "?callback=" + callbackUrl + "&" + ENABLE_OUTGOING_2LO_AUTHENTICATION_PARAMETER + "=" + actionParamValue);
        return enableOAuthURL.toString();
    }

    private String createRedirectUrl(HttpServletRequest req, boolean success, String message) {
        String callbackUrl = this.getRequiredParameter(req, CALLBACK_PARAM);
        if (callbackUrl.indexOf("?") == -1) {
            callbackUrl = callbackUrl + "?";
        }
        String redirectUrl = String.format("%s&outgoing_2lo_success=%s", callbackUrl, success);
        if (!StringUtils.isBlank((String)message)) {
            redirectUrl = redirectUrl + "&message=" + URIUtil.utf8Encode(message);
        }
        return redirectUrl;
    }
}

