/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth.oauth.servlets.serviceprovider;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.core.auth.oauth.servlets.AbstractOAuthConfigServlet;
import com.atlassian.applinks.core.docs.DocumentationLinker;
import com.atlassian.applinks.core.util.MessageFactory;
import com.atlassian.applinks.core.util.RendererContextBuilder;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.ui.BatchedJSONi18NBuilderFactory;
import com.atlassian.applinks.ui.auth.AdminUIAuthenticator;
import com.atlassian.oauth.util.RSAKeys;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.atlassian.templaterenderer.TemplateRenderer;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractConsumerServlet
extends AbstractOAuthConfigServlet {
    protected static final String CONSUMER_KEY = "key";
    protected static final String CONSUMER_NAME = "consumerName";
    protected static final String CONSUMER_DESCRIPTION = "description";
    protected static final String CONSUMER_PUBLIC_KEY = "publicKey";
    protected static final String CONSUMER_CALLBACK = "callback";
    protected static final String CONSUMER_TWO_LO_ALLOWED = "two-lo-enabled";
    protected static final String CONSUMER_EXECUTING_TWO_LO_USER = "two-lo-execute-as";
    protected static final String CONSUMER_TWO_LO_IMPERSONATION_ALLOWED = "two-lo-impersonation-enabled";
    protected static final String IS_SYSADMIN = "isSysadmin";
    public static final String OAUTH_INCOMING_CONSUMER_KEY = "oauth.incoming.consumerkey";
    public static final String OAUTH_INCOMING_ENABLED = "oauth-incoming-enabled";
    protected final RequestFactory requestFactory;
    protected static final String ENABLED_CONTEXT_PARAM = "enabled";
    protected final UserManager userManager;

    protected AbstractConsumerServlet(I18nResolver i18nResolver, MessageFactory messageFactory, TemplateRenderer templateRenderer, WebResourceManager webResourceManager, ApplicationLinkService applicationLinkService, AdminUIAuthenticator adminUIAuthenticator, RequestFactory requestFactory, BatchedJSONi18NBuilderFactory batchedJSONi18NBuilderFactory, DocumentationLinker documentationLinker, LoginUriProvider loginUriProvider, InternalHostApplication internalHostApplication, XsrfTokenAccessor xsrfTokenAccessor, XsrfTokenValidator xsrfTokenValidator, UserManager userManager) {
        super(i18nResolver, messageFactory, templateRenderer, webResourceManager, applicationLinkService, adminUIAuthenticator, batchedJSONi18NBuilderFactory, documentationLinker, loginUriProvider, internalHostApplication, xsrfTokenAccessor, xsrfTokenValidator);
        this.requestFactory = requestFactory;
        this.userManager = userManager;
    }

    protected final URI getCallbackUri(HttpServletRequest request, Map<String, String> fieldErrorMessages) {
        URI callback;
        String uriParam = request.getParameter(CONSUMER_CALLBACK);
        if (uriParam == null || StringUtils.isEmpty((String)uriParam)) {
            return null;
        }
        try {
            if (!uriParam.endsWith("/")) {
                uriParam = uriParam + "/";
            }
            callback = new URI(uriParam);
        }
        catch (URISyntaxException e) {
            fieldErrorMessages.put(CONSUMER_CALLBACK, this.i18nResolver.getText("auth.oauth.config.serviceprovider.invalid.uri"));
            return null;
        }
        if (!callback.isAbsolute()) {
            fieldErrorMessages.put(CONSUMER_CALLBACK, this.i18nResolver.getText("auth.oauth.config.serviceprovider.callback.uri.must.be.absolute"));
            return null;
        }
        if (!"http".equals(callback.getScheme()) && !"https".equals(callback.getScheme())) {
            fieldErrorMessages.put(CONSUMER_CALLBACK, this.i18nResolver.getText("auth.oauth.config.serviceprovider.callback.uri.must.be.http.or.https"));
            return null;
        }
        return callback;
    }

    protected final PublicKey getPublicKey(HttpServletRequest request, Map<String, String> fieldErrorMessages) {
        String publicKeyParam = this.checkRequiredFormParameter(request, CONSUMER_PUBLIC_KEY, fieldErrorMessages, "auth.oauth.config.serviceprovider.missing.public.key");
        if (publicKeyParam == null) {
            return null;
        }
        PublicKey publicKey = null;
        try {
            publicKey = publicKeyParam.startsWith("-----BEGIN CERTIFICATE-----") ? RSAKeys.fromEncodedCertificateToPublicKey((String)publicKeyParam) : RSAKeys.fromPemEncodingToPublicKey((String)publicKeyParam);
        }
        catch (GeneralSecurityException e) {
            fieldErrorMessages.put(CONSUMER_PUBLIC_KEY, this.i18nResolver.getText("auth.oauth.config.serviceprovider.invalid.public.key", new Serializable[]{e.getMessage()}));
        }
        return publicKey;
    }

    protected void render(String template, Map<String, Object> params, HttpServletRequest request, HttpServletResponse response, ApplicationLink applicationLink) throws IOException {
        RendererContextBuilder builder = new RendererContextBuilder(params);
        builder.put(ENABLED_CONTEXT_PARAM, applicationLink.getProperty(OAUTH_INCOMING_CONSUMER_KEY) != null);
        super.render(template, builder.build(), request, response);
    }

    protected boolean isSysadmin() {
        return this.userManager.isSystemAdmin(this.userManager.getRemoteUsername());
    }
}

