/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth.oauth;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.AuthorisationAdminURIGenerator;
import com.atlassian.applinks.api.AuthorisationURIGenerator;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.auth.types.OAuthAuthenticationProvider;
import com.atlassian.applinks.core.auth.oauth.ConsumerTokenStoreService;
import com.atlassian.applinks.core.auth.oauth.RequestUtil;
import com.atlassian.applinks.core.auth.oauth.ServiceProviderUtil;
import com.atlassian.applinks.core.auth.oauth.ThreeLeggedOAuthRequest;
import com.atlassian.applinks.core.rest.context.CurrentContext;
import com.atlassian.applinks.core.util.URIUtil;
import com.atlassian.applinks.host.spi.HostApplication;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.oauth.ServiceProvider;
import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.oauth.consumer.ConsumerToken;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class ThreeLeggedOAuthRequestFactoryImpl
implements ApplicationLinkRequestFactory,
AuthorisationAdminURIGenerator {
    private static final String OAUTH_ACCESS_TOKENS_ADMIN_SERVLET_LOCATION = "/plugins/servlet/oauth/users/access-tokens";
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final ApplicationLink applicationLink;
    private final ConsumerService consumerService;
    private final ConsumerTokenStoreService consumerTokenStoreService;
    private final RequestFactory requestFactory;
    private final UserManager userManager;
    private final HostApplication hostApplication;

    public ThreeLeggedOAuthRequestFactoryImpl(ApplicationLink applicationLink, AuthenticationConfigurationManager authenticationConfigurationManager, ConsumerService consumerService, ConsumerTokenStoreService consumerTokenStoreService, RequestFactory requestFactory, UserManager userManager, HostApplication hostApplication) {
        this.applicationLink = (ApplicationLink)Preconditions.checkNotNull((Object)applicationLink);
        this.authenticationConfigurationManager = (AuthenticationConfigurationManager)Preconditions.checkNotNull((Object)authenticationConfigurationManager);
        this.consumerService = (ConsumerService)Preconditions.checkNotNull((Object)consumerService);
        this.consumerTokenStoreService = (ConsumerTokenStoreService)Preconditions.checkNotNull((Object)consumerTokenStoreService);
        this.requestFactory = (RequestFactory)Preconditions.checkNotNull((Object)requestFactory);
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
        this.hostApplication = (HostApplication)Preconditions.checkNotNull((Object)hostApplication);
    }

    public ApplicationLinkRequest createRequest(Request.MethodType methodType, String uri) throws CredentialsRequiredException {
        Map config = this.authenticationConfigurationManager.getConfiguration(this.applicationLink.getId(), OAuthAuthenticationProvider.class);
        if (config == null) {
            throw new IllegalStateException(String.format("OAuth Authentication is not configured for application link %s", this.applicationLink));
        }
        ServiceProvider serviceProvider = ServiceProviderUtil.getServiceProvider(config, this.applicationLink);
        Request request = this.requestFactory.createRequest(methodType, uri);
        String username = (String)Preconditions.checkNotNull((Object)this.userManager.getRemoteUsername(), (Object)"You have to be logged in to use oauth authentication.");
        return new ThreeLeggedOAuthRequest(uri, methodType, request, serviceProvider, this.consumerService, this.retrieveConsumerToken(username), this.consumerTokenStoreService, this.applicationLink.getId(), username);
    }

    private ConsumerToken retrieveConsumerToken(String username) throws CredentialsRequiredException {
        ConsumerToken consumerToken = this.consumerTokenStoreService.getConsumerToken(this.applicationLink, username);
        if (consumerToken == null || consumerToken.isRequestToken()) {
            throw new CredentialsRequiredException((AuthorisationURIGenerator)this, "You do not have an authorized access token for the remote resource.");
        }
        return consumerToken;
    }

    @HtmlSafe
    public URI getAuthorisationURI() {
        HttpServletRequest request = CurrentContext.getHttpServletRequest();
        URI baseUrl = request != null ? RequestUtil.getBaseURLFromRequest(request, this.hostApplication.getBaseUrl()) : this.hostApplication.getBaseUrl();
        return URIUtil.uncheckedConcatenate(baseUrl, "/plugins/servlet/applinks/oauth/login-dance/authorize?applicationLinkID=" + URIUtil.utf8Encode(this.applicationLink.getId().get()));
    }

    @HtmlSafe
    public URI getAuthorisationURI(URI callback) {
        return URIUtil.uncheckedToUri(this.getAuthorisationURI().toString() + "&redirectUrl=" + URIUtil.utf8Encode((URI)Preconditions.checkNotNull((Object)callback)));
    }

    @HtmlSafe
    public URI getAuthorisationAdminURI() {
        return URIUtil.uncheckedConcatenate(this.applicationLink.getDisplayUrl(), OAUTH_ACCESS_TOKENS_ADMIN_SERVLET_LOCATION);
    }
}

