/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth.oauth;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.core.util.URIUtil;
import com.atlassian.oauth.ServiceProvider;
import com.google.common.base.Preconditions;
import java.net.URI;
import java.util.Map;

public class ServiceProviderUtil {
    public static ServiceProvider getServiceProvider(URI rpcUrl, URI displayUrl) {
        URI requestTokenUri = URIUtil.uncheckedConcatenate(rpcUrl, "/plugins/servlet/oauth/request-token");
        URI authorizeTokenUri = URIUtil.uncheckedConcatenate(displayUrl, "/plugins/servlet/oauth/authorize");
        URI accessTokenUri = URIUtil.uncheckedConcatenate(rpcUrl, "/plugins/servlet/oauth/access-token");
        return new ServiceProvider(requestTokenUri, authorizeTokenUri, accessTokenUri);
    }

    public static ServiceProvider getServiceProvider(Map<String, String> config, ApplicationLink applicationLink) {
        if (config.containsKey("consumerKey.outbound")) {
            String accessTokenUrl = ServiceProviderUtil.makeAbsoluteUrl(config.get("serviceProvider.accessTokenUrl"), applicationLink.getRpcUrl());
            String requestTokenUrl = ServiceProviderUtil.makeAbsoluteUrl(config.get("serviceProvider.requestTokenUrl"), applicationLink.getRpcUrl());
            String authorizeUrl = ServiceProviderUtil.makeAbsoluteUrl(config.get("serviceProvider.authorizeUrl"), applicationLink.getDisplayUrl());
            return new ServiceProvider(URI.create(requestTokenUrl), URI.create(authorizeUrl), URI.create(accessTokenUrl));
        }
        return ServiceProviderUtil.getServiceProvider(applicationLink.getRpcUrl(), applicationLink.getDisplayUrl());
    }

    protected static String makeAbsoluteUrl(String uri, URI baseUri) {
        Preconditions.checkNotNull((Object)uri);
        Preconditions.checkNotNull((Object)baseUri);
        if (uri.startsWith("/")) {
            return baseUri.resolve(uri).toASCIIString();
        }
        return uri;
    }
}

