/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth.oauth;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.auth.Anonymous;
import com.atlassian.applinks.core.util.URIUtil;
import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.Request;
import com.atlassian.oauth.util.Check;
import com.atlassian.oauth.util.RSAKeys;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.oauth.OAuth;
import net.oauth.OAuthMessage;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class OAuthHelper {
    private static final String CONSUMER_INFO_PATH = "/plugins/servlet/oauth/consumer-info";
    private static final Function<Map.Entry<String, String>, Request.Parameter> toRequestParameters = new Function<Map.Entry<String, String>, Request.Parameter>(){

        public Request.Parameter apply(Map.Entry<String, String> p) {
            Check.notNull(p, (Object)"parameter");
            return new Request.Parameter(p.getKey(), p.getValue());
        }
    };
    private static final Function<Request.Parameter, OAuth.Parameter> toOAuthParameters = new Function<Request.Parameter, OAuth.Parameter>(){

        public OAuth.Parameter apply(Request.Parameter p) {
            Check.notNull((Object)p, (Object)"parameter");
            return new OAuth.Parameter(p.getName(), p.getValue());
        }
    };

    private OAuthHelper() {
    }

    public static boolean isOAuthPluginInstalled(ApplicationLink applicationLink) {
        boolean oAuthPluginInstalled = false;
        try {
            Consumer consumer = OAuthHelper.fetchConsumerInformation(applicationLink);
            return consumer.getKey() != null;
        }
        catch (ResponseException responseException) {
            return false;
        }
    }

    public static Consumer fetchConsumerInformation(ApplicationLink applicationLink) throws ResponseException {
        Request request = Anonymous.createAnonymousRequest((ApplicationLink)applicationLink, (Request.MethodType)Request.MethodType.GET, (String)URIUtil.uncheckedConcatenate(applicationLink.getRpcUrl(), CONSUMER_INFO_PATH).toString());
        request.setHeader("Accept", "application/xml");
        ConsumerInformationResponseHandler handler = new ConsumerInformationResponseHandler();
        request.execute((ResponseHandler)handler);
        return handler.getConsumer();
    }

    public static OAuthMessage asOAuthMessage(com.atlassian.oauth.Request request) {
        Check.notNull((Object)request, (Object)"request");
        return new OAuthMessage(request.getMethod().name(), request.getUri().toString(), (Collection)ImmutableList.copyOf(OAuthHelper.asOAuthParameters(request.getParameters())));
    }

    public static Iterable<OAuth.Parameter> asOAuthParameters(Iterable<Request.Parameter> requestParameters) {
        Check.notNull(requestParameters, (Object)"requestParameters");
        return Iterables.transform(requestParameters, toOAuthParameters);
    }

    public static Iterable<Request.Parameter> fromOAuthParameters(List<? extends Map.Entry<String, String>> oauthParameters) {
        Check.notNull(oauthParameters, (Object)"oauthParameters");
        return Iterables.transform(oauthParameters, toRequestParameters);
    }

    private static class ConsumerInformationResponseHandler
    implements ResponseHandler {
        private Consumer consumer;

        private ConsumerInformationResponseHandler() {
        }

        public void handle(Response response) throws ResponseException {
            if (response.getStatusCode() != 200) {
                throw new ResponseException("Server responded with an error");
            }
            String contentTypeHeader = response.getHeader("Content-Type");
            if (contentTypeHeader != null && !contentTypeHeader.toLowerCase().startsWith("application/xml")) {
                throw new ResponseException("Server sent an invalid response");
            }
            try {
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document doc = docBuilder.parse(response.getResponseBodyAsStream());
                String consumerKey = doc.getElementsByTagName("key").item(0).getTextContent();
                String name = doc.getElementsByTagName("name").item(0).getTextContent();
                PublicKey publicKey = RSAKeys.fromPemEncodingToPublicKey((String)doc.getElementsByTagName("publicKey").item(0).getTextContent());
                String description = null;
                if (doc.getElementsByTagName("description").getLength() > 0) {
                    description = doc.getElementsByTagName("description").item(0).getTextContent();
                }
                URI callback = null;
                if (doc.getElementsByTagName("callback").getLength() > 0) {
                    callback = new URI(doc.getElementsByTagName("callback").item(0).getTextContent());
                }
                this.consumer = Consumer.key((String)consumerKey).name(name).publicKey(publicKey).description(description).callback(callback).build();
            }
            catch (ParserConfigurationException e) {
                throw new ResponseException("Unable to parse consumer information", (Throwable)e);
            }
            catch (SAXException e) {
                throw new ResponseException("Unable to parse consumer information", (Throwable)e);
            }
            catch (IOException e) {
                throw new ResponseException("Unable to parse consumer information", (Throwable)e);
            }
            catch (DOMException e) {
                throw new ResponseException("Unable to parse consumer information", (Throwable)e);
            }
            catch (URISyntaxException e) {
                throw new ResponseException("Unable to parse consumer information, callback is not a valid URL", (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                throw new ResponseException("Unable to parse consumer information, no RSA providers are installed", (Throwable)e);
            }
            catch (InvalidKeySpecException e) {
                throw new ResponseException("Unable to parse consumer information, the public key is not a validly encoded RSA public key", (Throwable)e);
            }
        }

        public Consumer getConsumer() {
            return this.consumer;
        }
    }
}

