/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.applinks.core.auth.oauth;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.AuthorisationAdminURIGenerator;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.auth.types.OAuthAuthenticationProvider;
import com.atlassian.applinks.core.RedirectController;
import com.atlassian.applinks.core.auth.oauth.ConsumerTokenStoreService;
import com.atlassian.applinks.core.auth.oauth.OAuthMessageProblemException;
import com.atlassian.applinks.core.auth.oauth.OAuthPermissionDeniedException;
import com.atlassian.applinks.core.auth.oauth.OAuthTokenRetriever;
import com.atlassian.applinks.core.auth.oauth.RequestUtil;
import com.atlassian.applinks.core.auth.oauth.ServiceProviderUtil;
import com.atlassian.applinks.core.util.WebResources;
import com.atlassian.applinks.host.spi.InternalHostApplication;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.applinks.ui.validators.CallbackParameterValidator;
import com.atlassian.oauth.ServiceProvider;
import com.atlassian.oauth.consumer.ConsumerService;
import com.atlassian.oauth.consumer.ConsumerToken;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuth;
import net.oauth.OAuthProblemException;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthApplinksServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(OAuthApplinksServlet.class);
    private final ConsumerTokenStoreService consumerTokenStoreService;
    private final OAuthTokenRetriever oAuthTokenRetriever;
    private final UserManager userManager;
    private final I18nResolver i18nResolver;
    private final WebResourceManager webResourceManager;
    private final TemplateRenderer templateRenderer;
    private final AuthenticationConfigurationManager authenticationConfigurationManager;
    private final ConsumerService consumerService;
    private final InternalHostApplication internalHostApplication;
    private final CallbackParameterValidator callbackParameterValidator;
    private final ApplicationLinkService applicationLinkService;
    private final RedirectController redirectController;
    public static final String AUTHORIZE_PATH = "authorize";
    public static final String ACCESS_PATH = "access";
    @VisibleForTesting
    protected static final String APPLICATION_LINK_ID_PARAM = "applicationLinkID";
    private static final String REDIRECT_URL_PARAM = "redirectUrl";
    private static final String TEMPLATE = "auth/oauth/oauth_dance.vm";

    public OAuthApplinksServlet(ConsumerTokenStoreService consumerTokenStoreService, OAuthTokenRetriever oAuthTokenRetriever, UserManager userManager, I18nResolver i18nResolver, WebResourceManager webResourceManager, TemplateRenderer templateRenderer, AuthenticationConfigurationManager authenticationConfigurationManager, ConsumerService consumerService, InternalHostApplication internalHostApplication, CallbackParameterValidator callbackParameterValidator, ApplicationLinkService applicationLinkService, RedirectController redirectController) {
        this.consumerTokenStoreService = consumerTokenStoreService;
        this.oAuthTokenRetriever = oAuthTokenRetriever;
        this.userManager = userManager;
        this.i18nResolver = i18nResolver;
        this.webResourceManager = webResourceManager;
        this.templateRenderer = templateRenderer;
        this.authenticationConfigurationManager = authenticationConfigurationManager;
        this.consumerService = consumerService;
        this.internalHostApplication = internalHostApplication;
        this.callbackParameterValidator = callbackParameterValidator;
        this.applicationLinkService = applicationLinkService;
        this.redirectController = redirectController;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ApplicationLink applicationLink;
        Map<String, Object> context = this.createVelocityContext(resp);
        String applicationLinkId = this.getApplicationLinkId(req);
        if (this.userManager.getRemoteUser(req) == null) {
            context.put("applinkId", StringEscapeUtils.escapeHtml((String)applicationLinkId));
            context.put("error", this.i18nResolver.getText("auth.oauth.config.error.not.loggedin"));
            this.templateRenderer.render(TEMPLATE, context, (Writer)resp.getWriter());
            return;
        }
        if (StringUtils.isBlank((String)applicationLinkId)) {
            context.put("error", this.i18nResolver.getText("auth.oauth.config.error.link.id.empty"));
            this.templateRenderer.render(TEMPLATE, context, (Writer)resp.getWriter());
            return;
        }
        try {
            applicationLink = this.applicationLinkService.getApplicationLink(new ApplicationId(applicationLinkId));
        }
        catch (TypeNotInstalledException e) {
            LOG.error("Failed to get application link", (Throwable)e);
            context.put("error", this.i18nResolver.getText("auth.oauth.config.error.link.type.not.loaded", new Serializable[]{applicationLinkId, e.getType()}));
            this.templateRenderer.render(TEMPLATE, context, (Writer)resp.getWriter());
            return;
        }
        if (applicationLink == null) {
            context.put("error", this.i18nResolver.getText("auth.oauth.config.error.link.id", new Serializable[]{applicationLinkId}));
            this.templateRenderer.render(TEMPLATE, context, (Writer)resp.getWriter());
            return;
        }
        context.put("applinkId", applicationLink.getId().toString());
        if (!this.authenticationConfigurationManager.isConfigured(applicationLink.getId(), OAuthAuthenticationProvider.class)) {
            context.put("error", this.i18nResolver.getText("auth.oauth.config.error.not.configured", new Serializable[]{applicationLink.toString()}));
            this.templateRenderer.render(TEMPLATE, context, (Writer)resp.getWriter());
            return;
        }
        String token = this.getToken(req);
        try {
            if (StringUtils.isBlank((String)token) || req.getPathInfo().endsWith(AUTHORIZE_PATH)) {
                this.obtainAndAuthorizeRequestToken(applicationLink, resp, req);
            } else if (req.getPathInfo().endsWith(ACCESS_PATH)) {
                this.getAccessToken(token, applicationLink, req);
                String redirectUrl = this.getRedirectUrl(req);
                if (StringUtils.isBlank((String)redirectUrl)) {
                    URI authAdminUri = null;
                    ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory();
                    if (requestFactory instanceof AuthorisationAdminURIGenerator) {
                        authAdminUri = ((AuthorisationAdminURIGenerator)requestFactory).getAuthorisationAdminURI();
                    }
                    context.put("authAdminUri", authAdminUri == null ? "" : authAdminUri.toString());
                    this.templateRenderer.render(TEMPLATE, context, (Writer)resp.getWriter());
                    return;
                }
                this.redirectController.redirectOrPrintRedirectionWarning(resp, redirectUrl);
            }
        }
        catch (Exception e) {
            LOG.error("An error occurred when performing the oauth 'dance' for application link '" + applicationLink + "'", (Throwable)e);
            if (e.getCause() instanceof OAuthProblemException) {
                OAuthProblemException oAuthProblem = (OAuthProblemException)e.getCause();
                String problem = oAuthProblem.getProblem();
                if (problem.equals("consumer_key_unknown")) {
                    context.put("error", this.i18nResolver.getText("auth.oauth.config.error.dance.oauth.problem.consumer.unknown", new Serializable[]{this.internalHostApplication.getName(), applicationLink.getName()}));
                } else if (problem.equals("token_rejected")) {
                    context.put("error", this.i18nResolver.getText("auth.oauth.config.error.dance.oauth.problem.token.rejected"));
                } else {
                    context.put("error", this.i18nResolver.getText("auth.oauth.config.error.dance.oauth.problem", new Serializable[]{applicationLink.toString(), oAuthProblem.getProblem()}));
                }
            } else if (e instanceof OAuthPermissionDeniedException) {
                context.put("warningTitle", this.i18nResolver.getText("auth.oauth.config.dance.denied.title"));
                context.put("warningMessage", this.i18nResolver.getText("auth.oauth.config.dance.denied.message", new Serializable[]{applicationLink.getName()}));
            } else if (e instanceof OAuthMessageProblemException) {
                context.put("error", this.i18nResolver.getText("auth.oauth.config.error.dance", new Serializable[]{applicationLink.toString()}));
                ArrayList errorDetails = Lists.newArrayList();
                for (OAuth.Parameter param : ((OAuthMessageProblemException)((Object)e)).getParameters()) {
                    String oAuthParam = param.getKey() + ": '" + param.getValue() + "'";
                    errorDetails.add(oAuthParam);
                }
                LOG.error("Error during OAuth Dance, OAuth Parameters '%s'", (Object)StringUtils.join((Collection)errorDetails, (String)","));
                context.put("errorDetails", errorDetails);
            } else if (e instanceof ResponseException) {
                context.put("error", this.i18nResolver.getText("auth.oauth.config.error.dance", new Serializable[]{applicationLink.toString()}));
                context.put("errorDetails", Lists.newArrayList((Object[])new String[]{e.getLocalizedMessage()}));
            } else {
                context.put("error", this.i18nResolver.getText("auth.oauth.config.error.dance", new Serializable[]{applicationLink.toString()}));
            }
            String redirectUrl = this.getValidatedRedirectUrl(req);
            if (redirectUrl == null) {
                redirectUrl = "#";
            }
            context.put(REDIRECT_URL_PARAM, redirectUrl);
            this.templateRenderer.render(TEMPLATE, context, (Writer)resp.getWriter());
            return;
        }
    }

    private Map<String, Object> createVelocityContext(HttpServletResponse resp) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("i18n", this.i18nResolver);
        resp.setContentType("text/html");
        this.webResourceManager.requireResource("com.atlassian.applinks.applinks-plugin:oauth-dance");
        StringWriter stringWriter = new StringWriter();
        this.webResourceManager.includeResources((Writer)stringWriter, UrlMode.RELATIVE);
        WebResources webResources = new WebResources();
        webResources.setIncludedResources(stringWriter.getBuffer().toString());
        context.put("webResources", webResources);
        return context;
    }

    private String getToken(HttpServletRequest req) {
        return req.getParameter("oauth_token");
    }

    private void getAccessToken(String requestToken, ApplicationLink applicationLink, HttpServletRequest request) throws ResponseException {
        String username = this.getRemoteUsername(request);
        ConsumerToken requestTokenPair = this.consumerTokenStoreService.getConsumerToken(applicationLink, username);
        if (requestTokenPair == null) {
            throw new ResponseException("Cannot get access token as no request token pair can be found");
        }
        if (requestTokenPair.isAccessToken()) {
            return;
        }
        if (!requestToken.equals(requestTokenPair.getToken())) {
            throw new ResponseException("The oauth_token in the request is not the same as the token persisted in the system.");
        }
        Map config = this.authenticationConfigurationManager.getConfiguration(applicationLink.getId(), OAuthAuthenticationProvider.class);
        ServiceProvider serviceProvider = ServiceProviderUtil.getServiceProvider(config, applicationLink);
        String requestVerifier = request.getParameter("oauth_verifier");
        String consumerKey = this.getConsumerKey(applicationLink);
        ConsumerToken accessToken = this.oAuthTokenRetriever.getAccessToken(serviceProvider, requestTokenPair, requestVerifier, consumerKey);
        this.consumerTokenStoreService.removeConsumerToken(applicationLink.getId(), username);
        this.consumerTokenStoreService.addConsumerToken(applicationLink, username, accessToken);
    }

    private void obtainAndAuthorizeRequestToken(ApplicationLink applicationLink, HttpServletResponse resp, HttpServletRequest req) throws ResponseException, IOException {
        Map config = this.authenticationConfigurationManager.getConfiguration(applicationLink.getId(), OAuthAuthenticationProvider.class);
        ServiceProvider serviceProvider = ServiceProviderUtil.getServiceProvider(config, applicationLink);
        String consumerKey = this.getConsumerKey(applicationLink);
        String redirectUrl = this.getRedirectUrl(req);
        URI baseUrl = RequestUtil.getBaseURLFromRequest(req, this.internalHostApplication.getBaseUrl());
        String redirectToMeUrl = baseUrl + "/plugins/servlet/applinks" + "/oauth/login-dance/" + ACCESS_PATH + "?" + APPLICATION_LINK_ID_PARAM + "=" + applicationLink.getId() + (redirectUrl != null ? "&redirectUrl=" + URLEncoder.encode(redirectUrl, "UTF-8") : "");
        ConsumerToken requestToken = this.oAuthTokenRetriever.getRequestToken(serviceProvider, consumerKey, redirectToMeUrl);
        this.consumerTokenStoreService.addConsumerToken(applicationLink, this.getRemoteUsername(req), requestToken);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("oauth_token", requestToken.getToken());
        parameters.put("oauth_callback", redirectToMeUrl);
        resp.sendRedirect(serviceProvider.getAuthorizeUri() + "?" + OAuth.formEncode(parameters.entrySet()));
    }

    private String getRemoteUsername(HttpServletRequest request) {
        UserProfile remoteUser = this.userManager.getRemoteUser(request);
        return remoteUser == null ? null : remoteUser.getUsername();
    }

    private String getConsumerKey(ApplicationLink applicationLink) {
        Map config = this.authenticationConfigurationManager.getConfiguration(applicationLink.getId(), OAuthAuthenticationProvider.class);
        if (config.containsKey("consumerKey.outbound")) {
            return (String)config.get("consumerKey.outbound");
        }
        return this.consumerService.getConsumer().getKey();
    }

    private String getApplicationLinkId(HttpServletRequest req) {
        return req.getParameter(APPLICATION_LINK_ID_PARAM);
    }

    private String getRedirectUrl(HttpServletRequest req) {
        return req.getParameter(REDIRECT_URL_PARAM);
    }

    private String getValidatedRedirectUrl(HttpServletRequest req) {
        String redirectUrl = req.getParameter(REDIRECT_URL_PARAM);
        if (redirectUrl != null) {
            this.callbackParameterValidator.validate(redirectUrl);
        }
        return redirectUrl;
    }
}

