/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.application.host.plugin;

import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationPlugin;
import com.atlassian.application.host.plugin.AmpsBuildDateParser;
import com.atlassian.application.host.plugin.DefaultApplicationPlugin;
import com.atlassian.application.host.plugin.PluginApplicationMetaData;
import com.atlassian.application.host.util.Arguments;
import com.atlassian.plugin.Plugin;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.atlassian.fugue.Option;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;

class PluginApplicationMetaDataBuilder {
    private ApplicationKey key;
    private String name;
    private Option<URI> configURI = Option.none();
    private Option<URI> postInstallURI = Option.none();
    private Option<URI> postUpdateURI = Option.none();
    private Option<URI> productHelpServerSpaceURI = Option.none();
    private Option<URI> productHelpCloudSpaceURI = Option.none();
    private String definitionModuleKey;
    private ApplicationPlugin primaryPlugin;
    private Iterable<ApplicationPlugin> applicationPlugins = Collections.emptyList();
    private Iterable<ApplicationPlugin> utilityPlugins = Collections.emptyList();
    private String descriptionKey;
    private String userCountKey;
    private Plugin plugin;
    private String defaultGroup;

    PluginApplicationMetaDataBuilder() {
    }

    PluginApplicationMetaDataBuilder key(ApplicationKey key) {
        this.key = Arguments.checkArgumentNotNull(key, "key is null");
        return this;
    }

    PluginApplicationMetaDataBuilder name(String name) {
        this.name = Arguments.checkArgumentNotBlank(name, "name is null");
        return this;
    }

    PluginApplicationMetaDataBuilder configURI(Option<URI> uri) {
        this.configURI = Arguments.checkArgumentNotNull(uri, "uri is null");
        return this;
    }

    PluginApplicationMetaDataBuilder postInstallURI(Option<URI> uri) {
        this.postInstallURI = Arguments.checkArgumentNotNull(uri, "uri is null");
        return this;
    }

    PluginApplicationMetaDataBuilder postUpdateURI(Option<URI> uri) {
        this.postUpdateURI = Arguments.checkArgumentNotNull(uri, "uri is null");
        return this;
    }

    PluginApplicationMetaDataBuilder productHelpServerSpaceURI(Option<URI> uri) {
        this.productHelpServerSpaceURI = Arguments.checkArgumentNotNull(uri, "help server space uri is null");
        return this;
    }

    PluginApplicationMetaDataBuilder productHelpCloudSpaceURI(Option<URI> uri) {
        this.productHelpCloudSpaceURI = Arguments.checkArgumentNotNull(uri, "help cloud space uri is null");
        return this;
    }

    PluginApplicationMetaDataBuilder definitionModuleKey(String definitionModuleKey) {
        this.definitionModuleKey = Arguments.checkArgumentNotBlank(definitionModuleKey, "definitionModuleKey");
        return this;
    }

    PluginApplicationMetaDataBuilder primaryPlugin(Plugin plugin) {
        this.plugin = Arguments.checkArgumentNotNull(plugin, "plugin");
        this.primaryPlugin = new DefaultApplicationPlugin(plugin.getKey(), ApplicationPlugin.PluginType.PRIMARY);
        return this;
    }

    PluginApplicationMetaDataBuilder applicationPlugins(Iterable<String> keys) {
        this.applicationPlugins = PluginApplicationMetaDataBuilder.createPlugins(keys, ApplicationPlugin.PluginType.APPLICATION);
        return this;
    }

    PluginApplicationMetaDataBuilder utilityPlugins(Iterable<String> keys) {
        this.utilityPlugins = PluginApplicationMetaDataBuilder.createPlugins(keys, ApplicationPlugin.PluginType.UTILITY);
        return this;
    }

    PluginApplicationMetaDataBuilder descriptionKey(String key) {
        this.descriptionKey = Arguments.checkArgumentNotBlank(key, "key");
        return this;
    }

    PluginApplicationMetaDataBuilder userCountKey(String key) {
        this.userCountKey = Arguments.checkArgumentNotBlank(key, "key");
        return this;
    }

    PluginApplicationMetaDataBuilder defaultGroup(String defaultGroup) {
        this.defaultGroup = Arguments.checkArgumentNotBlank(defaultGroup, "defaultGroup is null");
        return this;
    }

    private static List<ApplicationPlugin> createPlugins(Iterable<String> keys, ApplicationPlugin.PluginType pluginType) {
        Arguments.checkArgumentNotNull(keys, "keys");
        ArrayList metaData = Lists.newArrayList();
        for (String key : Sets.newHashSet(keys)) {
            if (key == null) {
                throw new IllegalArgumentException("keys contains a null value.");
            }
            metaData.add(new DefaultApplicationPlugin(key, pluginType));
        }
        return metaData;
    }

    PluginApplicationMetaData build() {
        Preconditions.checkState((this.key != null ? 1 : 0) != 0, (Object)"key is null");
        Preconditions.checkState((this.name != null ? 1 : 0) != 0, (Object)"productName is null");
        Preconditions.checkState((this.definitionModuleKey != null ? 1 : 0) != 0, (Object)"definitionModuleKey is null");
        Preconditions.checkState((this.primaryPlugin != null ? 1 : 0) != 0, (Object)"primaryPlugin is null");
        Preconditions.checkState((this.descriptionKey != null ? 1 : 0) != 0, (Object)"descriptionKey is null");
        Preconditions.checkState((this.userCountKey != null ? 1 : 0) != 0, (Object)"userCountKey is null");
        Preconditions.checkState((this.defaultGroup != null ? 1 : 0) != 0, (Object)"defaultGroup is null");
        return new DefaultPluginApplicationMetaData(this);
    }

    private static final class DefaultPluginApplicationMetaData
    implements PluginApplicationMetaData {
        private final ApplicationKey key;
        private ZonedDateTime buildDate;
        private String version;
        private final String name;
        private final Option<URI> configURI;
        private final Option<URI> postUpdateURI;
        private final Option<URI> postInstallURI;
        private final Option<URI> productHelpServerSpaceURI;
        private final Option<URI> productHelpCloudSpaceURI;
        private final String definitionModuleKey;
        private final ApplicationPlugin primaryPlugin;
        private final List<ApplicationPlugin> applicationPlugins;
        private final List<ApplicationPlugin> utilityPlugins;
        private final String descriptionKey;
        private final String userCountKey;
        private final WeakReference<Plugin> plugin;
        private final String defaultGroup;

        private DefaultPluginApplicationMetaData(PluginApplicationMetaDataBuilder builder) {
            this.key = builder.key;
            this.name = builder.name;
            this.configURI = builder.configURI;
            this.postUpdateURI = builder.postUpdateURI;
            this.postInstallURI = builder.postInstallURI;
            this.definitionModuleKey = builder.definitionModuleKey;
            this.primaryPlugin = builder.primaryPlugin;
            this.applicationPlugins = ImmutableList.copyOf((Iterable)builder.applicationPlugins);
            this.utilityPlugins = ImmutableList.copyOf((Iterable)builder.utilityPlugins);
            this.descriptionKey = builder.descriptionKey;
            this.userCountKey = builder.userCountKey;
            this.defaultGroup = builder.defaultGroup;
            this.productHelpServerSpaceURI = builder.productHelpServerSpaceURI;
            this.productHelpCloudSpaceURI = builder.productHelpCloudSpaceURI;
            this.plugin = new WeakReference<Plugin>(builder.plugin);
        }

        @Override
        public String getDefinitionModuleKey() {
            return this.definitionModuleKey;
        }

        @Override
        public Iterable<ApplicationPlugin> getPlugins() {
            ArrayList plugins = Lists.newArrayList();
            plugins.add(Collections.singleton(this.getPrimaryPlugin()));
            plugins.add(this.getApplicationPlugins());
            plugins.add(this.getUtilityPlugins());
            return Iterables.concat((Iterable)plugins);
        }

        @Override
        public ApplicationPlugin getPrimaryPlugin() {
            return this.primaryPlugin;
        }

        @Override
        public Iterable<ApplicationPlugin> getApplicationPlugins() {
            return this.applicationPlugins;
        }

        @Override
        public Iterable<ApplicationPlugin> getUtilityPlugins() {
            return this.utilityPlugins;
        }

        @Override
        public ApplicationKey getKey() {
            return this.key;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getVersion() {
            if (this.version == null) {
                Option op = Option.option((Object)((Plugin)this.plugin.get()));
                if (op.isDefined()) {
                    for (Plugin p : op) {
                        this.version = p.getPluginInformation().getVersion();
                    }
                } else {
                    throw new IllegalStateException("Plugin version is currently unknown");
                }
            }
            return this.version;
        }

        @Override
        public String getDescriptionKey() {
            return this.descriptionKey;
        }

        @Override
        public String getUserCountKey() {
            return this.userCountKey;
        }

        @Override
        public Option<URI> getConfigurationURI() {
            return this.configURI;
        }

        @Override
        public Option<URI> getPostInstallURI() {
            return this.postInstallURI;
        }

        @Override
        public Option<URI> getPostUpdateURI() {
            return this.postUpdateURI;
        }

        @Override
        public String getDefaultGroup() {
            return this.defaultGroup;
        }

        @Override
        public Option<URI> getProductHelpServerSpaceURI() {
            return this.productHelpServerSpaceURI;
        }

        @Override
        public Option<URI> getProductHelpCloudSpaceURI() {
            return this.productHelpCloudSpaceURI;
        }

        @Override
        public ZonedDateTime buildZonedDate() {
            if (this.buildDate == null) {
                Plugin plugin = (Plugin)this.plugin.get();
                if (plugin == null) {
                    throw new IllegalStateException("Plugin '" + this.getPrimaryPlugin().getPluginKey() + "' no longer exists.");
                }
                this.buildDate = (ZonedDateTime)new AmpsBuildDateParser().apply(plugin).getOrElse((Object)ZonedDateTime.ofInstant(Instant.EPOCH, ZoneId.systemDefault()));
            }
            return this.buildDate;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("key", (Object)this.key).append("buildDate", (Object)this.buildDate).append("productName", (Object)this.name).append("configURI", this.configURI).append("postUpdateURI", this.postUpdateURI).append("postInstallURI", this.postInstallURI).append("productHelpServerSpaceURI", this.productHelpServerSpaceURI).append("productHelpCloudSpaceURI", this.productHelpCloudSpaceURI).append("definitionModuleKey", (Object)this.definitionModuleKey).append("primaryPlugin", (Object)this.primaryPlugin).append("applicationPlugins", this.applicationPlugins).append("utilityPlugins", this.utilityPlugins).append("descriptionKey", (Object)this.descriptionKey).append("userCountKey", (Object)this.userCountKey).append("defaultGroup", (Object)this.defaultGroup).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DefaultPluginApplicationMetaData that = (DefaultPluginApplicationMetaData)o;
            return this.key.equals((Object)that.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }
}

