/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.application.host.plugin;

import com.atlassian.application.api.ApplicationAccess;
import com.atlassian.application.api.ApplicationKey;
import com.atlassian.application.api.ApplicationPlugin;
import com.atlassian.application.api.PluginApplication;
import com.atlassian.application.host.ApplicationConfigurationManager;
import com.atlassian.application.host.i18n.I18nResolver;
import com.atlassian.application.host.plugin.PluginApplicationMetaData;
import com.atlassian.application.host.util.Arguments;
import com.atlassian.sal.api.license.SingleProductLicenseDetailsView;
import com.google.common.base.Supplier;
import io.atlassian.fugue.Option;
import java.io.Serializable;
import java.net.URI;
import java.time.ZonedDateTime;

public final class PluginApplicationImpl
implements PluginApplication {
    private final PluginApplicationMetaData metaData;
    private final I18nResolver resolver;
    private final Supplier<Option<SingleProductLicenseDetailsView>> license;
    private final Supplier<ApplicationAccess> access;
    private final ApplicationConfigurationManager appConfigManager;

    public PluginApplicationImpl(PluginApplicationMetaData metaData, I18nResolver resolver, Supplier<Option<SingleProductLicenseDetailsView>> license, Supplier<ApplicationAccess> access, ApplicationConfigurationManager appConfigManager) {
        this.license = Arguments.checkArgumentNotNull(license, "license");
        this.metaData = Arguments.checkArgumentNotNull(metaData, "metaData");
        this.resolver = Arguments.checkArgumentNotNull(resolver, "resolver");
        this.access = Arguments.checkArgumentNotNull(access, "access");
        this.appConfigManager = Arguments.checkArgumentNotNull(appConfigManager, "appConfigManager");
    }

    public ApplicationKey getKey() {
        return this.metaData.getKey();
    }

    public String getName() {
        return this.metaData.getName();
    }

    public String getVersion() {
        return this.metaData.getVersion();
    }

    public String getDescription() {
        return this.resolver.getText(this.metaData.getDescriptionKey());
    }

    public String getUserCountDescription(Option<Integer> count) {
        return this.resolver.getText(this.metaData.getUserCountKey(), (Serializable)count.getOrElse((Object)-1));
    }

    public Option<URI> getConfigurationURI() {
        return this.metaData.getConfigurationURI();
    }

    public Option<URI> getPostInstallURI() {
        return this.metaData.getPostInstallURI();
    }

    public Option<URI> getPostUpdateURI() {
        return this.metaData.getPostUpdateURI();
    }

    public Option<URI> getProductHelpServerSpaceURI() {
        return this.metaData.getProductHelpServerSpaceURI();
    }

    public Option<URI> getProductHelpCloudSpaceURI() {
        return this.metaData.getProductHelpCloudSpaceURI();
    }

    public ZonedDateTime buildZonedDate() {
        return this.metaData.buildZonedDate();
    }

    public Option<SingleProductLicenseDetailsView> getLicense() {
        return (Option)this.license.get();
    }

    public ApplicationAccess getAccess() {
        return (ApplicationAccess)this.access.get();
    }

    public String getDefaultGroup() {
        return this.metaData.getDefaultGroup();
    }

    public void clearConfiguration() {
        this.appConfigManager.clearConfiguration(this.getKey());
    }

    public String getDefinitionModuleKey() {
        return this.metaData.getDefinitionModuleKey();
    }

    public Iterable<ApplicationPlugin> getPlugins() {
        return this.metaData.getPlugins();
    }

    public ApplicationPlugin getPrimaryPlugin() {
        return this.metaData.getPrimaryPlugin();
    }

    public Iterable<ApplicationPlugin> getApplicationPlugins() {
        return this.metaData.getApplicationPlugins();
    }

    public Iterable<ApplicationPlugin> getUtilityPlugins() {
        return this.metaData.getUtilityPlugins();
    }

    public String toString() {
        return "Plugin Application: " + this.getKey();
    }
}

