/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.application.host.plugin;

import com.atlassian.application.host.events.ApplicationDefinedEvent;
import com.atlassian.application.host.events.ApplicationUndefinedEvent;
import com.atlassian.application.host.plugin.ApplicationMetaDataModuleDescriptor;
import com.atlassian.application.host.util.Arguments;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import io.atlassian.fugue.Option;

public final class ApplicationEventListener {
    private final EventPublisher publisher;

    public ApplicationEventListener(EventPublisher publisher) {
        this.publisher = Arguments.checkArgumentNotNull(publisher, "publisher");
    }

    @EventListener
    public void pluginModuleDisabled(PluginModuleDisabledEvent event) {
        for (ApplicationMetaDataModuleDescriptor licenseRoleModuleDescriptor : this.asRole(event.getModule())) {
            this.publisher.publish((Object)new ApplicationUndefinedEvent(licenseRoleModuleDescriptor.getApplicationKey()));
        }
    }

    @EventListener
    public void pluginModuleEnabled(PluginModuleEnabledEvent event) {
        for (ApplicationMetaDataModuleDescriptor licenseRoleModuleDescriptor : this.asRole(event.getModule())) {
            this.publisher.publish((Object)new ApplicationDefinedEvent(licenseRoleModuleDescriptor.getApplicationKey()));
        }
    }

    public void register() {
        this.publisher.register((Object)this);
    }

    private Option<ApplicationMetaDataModuleDescriptor> asRole(ModuleDescriptor module) {
        if (module instanceof ApplicationMetaDataModuleDescriptor) {
            return Option.some((Object)((ApplicationMetaDataModuleDescriptor)module));
        }
        return Option.none(ApplicationMetaDataModuleDescriptor.class);
    }
}

