package com.atlassian.application.host.events;

import com.atlassian.application.api.ApplicationKey;

/**
 * An event fired when an {@link com.atlassian.application.api.Application} becomes known to the host (e.g. JIRA). An
 * application will generally become defined when the plugins that make up an application are installed into the host.
 *
 * <p>NOTE: A defined application may or may not be licensed.
 *
 * @since 1.0
 */
public final class ApplicationDefinedEvent extends ApplicationEvent
{
    /**
     * Create a new event for the specified application.
     *
     * @param key the key of the application.
     */
    public ApplicationDefinedEvent(final ApplicationKey key)
    {
        super(key);
    }

    @Override
    public String toString()
    {
        return String.format("Application Defined [%s].", getKey());
    }
}
