package com.atlassian.application.host.plugin;

import com.atlassian.application.api.ApplicationPlugin;
import org.apache.commons.lang3.builder.ToStringBuilder;

import static com.atlassian.application.host.util.Arguments.checkArgumentNotBlank;
import static com.atlassian.application.host.util.Arguments.checkArgumentNotNull;

/**
 * Default implementation of {@link com.atlassian.application.api.ApplicationPlugin}
 *
 * @since 1.0
 */
final class DefaultApplicationPlugin implements ApplicationPlugin
{
    private final String key;
    private final PluginType type;

    DefaultApplicationPlugin(final String key, final PluginType type)
    {
        this.key = checkArgumentNotBlank(key, "key");
        this.type = checkArgumentNotNull(type, "type");
    }

    @Override
    public String getPluginKey()
    {
        return key;
    }

    @Override
    public PluginType getType()
    {
        return type;
    }

    @Override
    public String toString()
    {
        return new ToStringBuilder(this)
                .append("key", key)
                .append("type", type)
                .toString();
    }
}
