package com.atlassian.application.host.events;

import com.atlassian.application.api.ApplicationKey;

/**
 * An event fired when an {@link com.atlassian.application.api.Application} is removed from the host application. An
 * application will generally become undefined when the plugins that make up an application are uninstalled.
 *
 * @since 1.0
 */
public final class ApplicationUndefinedEvent extends ApplicationEvent
{
    /**
     * Create a new event for the specified application.
     *
     * @param key the key of the application.
     */
    public ApplicationUndefinedEvent(final ApplicationKey key)
    {
        super(key);
    }

    @Override
    public String toString()
    {
        return String.format("Application Undefined [%s].", getKey());
    }
}
