package com.atlassian.application.host;

import com.atlassian.application.api.ApplicationKey;

/**
 * Manager used to manage application configuration.
 *
 * @since v1.0
 */
public interface ApplicationConfigurationManager
{
    /**
     * Clear the configuration for the specified application. This is typically performed when an application gets
     * uninstalled and cleanup needs to be performed.
     *
     * @param applicationKey key used to identify the application.
     */
    void clearConfiguration(ApplicationKey applicationKey);
}
