package com.atlassian.application.host;

import com.atlassian.application.api.ApplicationAccess;
import com.atlassian.application.api.ApplicationKey;
import org.joda.time.DateTime;

/**
 * Factory for {@link com.atlassian.application.api.ApplicationAccess}.
 *
 * @since v1.0
 */
public interface ApplicationAccessFactory
{
    /**
     * Creates an {@link com.atlassian.application.api.ApplicationAccess} from the passed
     * {@link com.atlassian.application.api.ApplicationKey} and {@code buildDate}.
     *
     * @param key the key of the application.
     * @param buildDate the build date of the application.
     *
     * @return the {@code ApplicationAccess} associated with the passed key and {@code buildDate}.
     */
    ApplicationAccess access(ApplicationKey key, DateTime buildDate);
}
