package com.atlassian.application.api;

/**
 * Representation of a plugin in an {@link Application}.
 *
 * @since v1.0
 */
public interface ApplicationPlugin
{
    /**
     * An enumeration holding the different types of plugins.
     */
    enum PluginType
    {
        /**
         * A plugin that defines the application. The primary plugin may also provide application functionality.
         */
        PRIMARY,

        /**
         * A plugin that provides fundamental features for the application. The application owns the plugin (i.e the
         * plugin will not work without the primary of the application).
         */
        APPLICATION,

        /**
         * A plugin that provides functionality for the primary and application plugins. This plugin is not owned by
         * the application (i.e. the plugin will work without the primary of the application).
         */
        UTILITY
    }

    /**
     * The key of the plugin.
     *
     * @return the key of the plugin.
     */
    String getPluginKey();

    /**
     * Return the type of this plugin.
     *
     * @return the type of this plugin.
     */
    PluginType getType();
}
