/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ant.tasks;

import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import org.jruby.ext.posix.POSIX;
import org.jruby.ext.posix.POSIXFactory;
import org.jruby.ext.posix.POSIXHandler;

public class PermissionsUtils {
    private static POSIX posix = POSIXFactory.getPOSIX((POSIXHandler)new AntPOSIXHandler(), (boolean)true);

    public static int getPermissions(File file) {
        return posix.stat(file.getAbsolutePath()).mode() & 0x1FF;
    }

    public static void setPermissions(File file, int perms) {
        posix.chmod(file.getAbsolutePath(), perms);
    }

    public static class AntPOSIXHandler
    implements POSIXHandler {
        public File getCurrentWorkingDirectory() {
            return new File(".");
        }

        public String[] getEnv() {
            return new String[0];
        }

        public PrintStream getErrorStream() {
            return System.err;
        }

        public InputStream getInputStream() {
            return System.in;
        }

        public PrintStream getOutputStream() {
            return System.out;
        }

        public int getPID() {
            return 0;
        }

        public boolean isVerbose() {
            return false;
        }

        public void unimplementedError(String message) {
            throw new RuntimeException(message);
        }

        public void warn(POSIXHandler.WARNING_ID arg0, String arg1, Object ... arg2) {
            System.err.println(arg0 + ": " + String.format(arg1, arg2));
        }

        public void error(POSIX.ERRORS error, String extraData) {
            System.err.println(error + ": " + extraData);
        }
    }
}

