(function($) {
    var contextPath =
        typeof AJS.contextPath == "function" ? AJS.contextPath() :
        typeof AJS.Confluence != "undefined" ? AJS.Confluence.getContextPath() :
        window.contextPath != null ? window.contextPath : "";

    AJS.toInit(function ($) {
        var $form = $("#analytics-enable-form");
        $form.submit(function(e) {
            e.preventDefault();
            $(".buttons .loading").removeClass("hidden");
            $.ajax({
                url: contextPath + "/rest/analytics/1.0/config/enable",
                type: "PUT",
                contentType: "application/json",
                data: JSON.stringify({analyticsEnabled: $form.find('input[name=analyticsEnabled]:checked').val() == 'true'}),
                success: function() {
                    AJS.messages.generic("#analytics-enable-form", {
                        body: AJS.I18n.getText("analytics.configuration.enable.success"),
                        id: "config-updated",
                        insert: "append",
                        closeable: false,
                        shadowed: true,
                        fadeout: true
                    });
                },
                error: function() {
                    AJS.messages.error("#analytics-enable-form", {
                        body: AJS.I18n.getText("analytics.configuration.enable.error"),
                        id: "config-update-failed",
                        insert: "append",
                        closeable: false,
                        shadowed: true,
                        fadeout: true
                    });
                },
                complete: function () {
                    $(".buttons .loading").addClass("hidden");
                }
            });
        });
    });
})(AJS.$);
