/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.serialize;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.analytics.api.events.MauEvent;
import com.atlassian.analytics.client.api.browser.BrowserEvent;
import com.atlassian.analytics.client.extractor.PropertyExtractor;
import com.atlassian.analytics.client.hash.AnalyticsEmailHasher;
import com.atlassian.analytics.client.properties.AnalyticsPropertyService;
import com.atlassian.analytics.client.sen.SenProvider;
import com.atlassian.analytics.client.serialize.IsMauEventAvailable;
import com.atlassian.analytics.client.serialize.RequestInfo;
import com.atlassian.analytics.event.EventUtils;
import com.atlassian.analytics.event.RawEvent;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheLoader;
import com.atlassian.cache.CacheManager;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Optional;
import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.springframework.beans.BeanWrapperImpl;

public class EventSerializer {
    private static final String MAU_EMAIL_KEY = "email";
    private static final String MAU_EMAIL_HASH_KEY = "emailHash";
    protected static final String MAU_SUPPRESSED_USERNAME_VALUE = "suppressed";
    private final PropertyExtractor propertyExtractor;
    private final AnalyticsPropertyService applicationProperties;
    private final SenProvider senProvider;
    private final AtomicReference<String> server = new AtomicReference();
    private final String product;
    private final String version;
    private final Cache<Optional<String>, Optional<String>> emailHashCache;
    private final LazyReference<Boolean> isMauEventAvailable = new IsMauEventAvailable();

    public EventSerializer(AnalyticsPropertyService applicationProperties, PropertyExtractor propertyExtractor, SenProvider senProvider, CacheManager cacheManager, final AnalyticsEmailHasher analyticsEmailHasher) {
        this.applicationProperties = applicationProperties;
        this.product = applicationProperties.getDisplayName().toLowerCase();
        this.version = applicationProperties.getVersion();
        this.propertyExtractor = propertyExtractor;
        this.senProvider = senProvider;
        this.emailHashCache = cacheManager.getCache(EventSerializer.class.getName() + ".emailHash", (CacheLoader)new CacheLoader<Optional<String>, Optional<String>>(){

            public Optional<String> load(Optional<String> email) {
                return email.isPresent() ? Optional.fromNullable((Object)analyticsEmailHasher.hash((String)email.get())) : Optional.absent();
            }
        }, new CacheSettingsBuilder().local().expireAfterAccess(2L, TimeUnit.HOURS).build());
    }

    public Supplier<RawEvent> toAnalyticsEvent(final Object event, final @Nullable String sessionId, final RequestInfo requestInfo) {
        return new Supplier<RawEvent>(){
            private final RawEvent.Builder builder;
            private final Map<String, Object> properties;
            {
                String originalName = EventSerializer.this.propertyExtractor.extractName(event);
                Map<String, Object> originalProperties = EventSerializer.this.extractEventProperties(event);
                String name = EventUtils.getBrowserEventName((String)originalName, originalProperties);
                this.properties = EventUtils.getBrowserEventProperties((String)originalName, originalProperties);
                String subProduct = EventSerializer.this.propertyExtractor.extractSubProduct(event, EventSerializer.this.product);
                String server = EventSerializer.this.getServer();
                long currentTime = EventSerializer.this.getCurrentTime();
                long clientTime = (Long)EventSerializer.this.getClientTime(event).or((Object)currentTime);
                String user = this.extractUser();
                String applicationAccess = EventSerializer.this.propertyExtractor.getApplicationAccess();
                String requestCorrelationId = this.extractRequestCorrelationId(requestInfo);
                String session = sessionId != null ? Integer.toString(sessionId.hashCode()) : null;
                this.builder = new RawEvent.Builder().name(name).server(server).product(EventSerializer.this.product).subproduct(subProduct).version(EventSerializer.this.version).user(user).session(session).clientTime(clientTime).receivedTime(currentTime).sourceIP(requestInfo.getSourceIp()).atlPath(requestInfo.getAtlPath()).appAccess(applicationAccess).requestCorrelationId(requestCorrelationId);
            }

            private String extractUser() {
                if (EventSerializer.this.isMauEvent(event)) {
                    return EventSerializer.MAU_SUPPRESSED_USERNAME_VALUE;
                }
                return EventSerializer.this.propertyExtractor.extractUser(event, this.properties);
            }

            private String extractRequestCorrelationId(RequestInfo requestInfo2) {
                if (EventSerializer.this.isMauEvent(event)) {
                    return "";
                }
                return EventSerializer.this.propertyExtractor.extractRequestCorrelationId(requestInfo2);
            }

            public RawEvent get() {
                Map eventProperties = EventSerializer.this.hashEmailPropertyForMauEvent(event, this.properties);
                String sen = EventSerializer.this.senProvider.getSen();
                return this.builder.properties(eventProperties).sen(sen).build();
            }
        };
    }

    private Map<String, Object> hashEmailPropertyForMauEvent(Object event, Map<String, Object> properties) {
        if (this.isMauEvent(event)) {
            HashMap eventProperties = Maps.newHashMap(properties);
            Optional emailHash = (Optional)this.emailHashCache.get((Object)Optional.fromNullable((Object)((String)eventProperties.get(MAU_EMAIL_KEY))));
            if (emailHash.isPresent()) {
                eventProperties.put(MAU_EMAIL_HASH_KEY, emailHash.get());
            }
            eventProperties.remove(MAU_EMAIL_KEY);
            return eventProperties;
        }
        return properties;
    }

    private boolean isMauEvent(Object event) {
        return (Boolean)this.isMauEventAvailable.get() != false && event instanceof MauEvent;
    }

    private long getCurrentTime() {
        return System.currentTimeMillis();
    }

    private Optional<Long> getClientTime(Object event) {
        if (event instanceof BrowserEvent) {
            return Optional.of((Object)((BrowserEvent)event).getClientTime());
        }
        return Optional.absent();
    }

    public Map<String, Object> extractEventProperties(Object event) {
        HashMap result = Maps.newHashMap();
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(event);
        for (PropertyDescriptor property : beanWrapper.getPropertyDescriptors()) {
            String name = property.getName();
            if (this.propertyExtractor.isExcluded(name) || this.isEventName(property)) continue;
            Object value = beanWrapper.getPropertyValue(name);
            result.putAll(this.propertyExtractor.extractProperty(name, value));
        }
        result.putAll(this.propertyExtractor.enrichProperties(event));
        return result;
    }

    private boolean isEventName(PropertyDescriptor property) {
        Method readMethod = property.getReadMethod();
        if (readMethod != null) {
            for (Annotation annotation : readMethod.getDeclaredAnnotations()) {
                if (!annotation.annotationType().equals(EventName.class)) continue;
                return true;
            }
        }
        return false;
    }

    private String getServer() {
        String result = this.server.get();
        if (result != null) {
            return result;
        }
        String baseUrl = this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
        if (baseUrl == null) {
            return "-";
        }
        try {
            result = new URL(baseUrl).getHost();
            this.server.set(result);
            return result;
        }
        catch (MalformedURLException e) {
            return "-";
        }
    }
}

