/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.sender;

import com.atlassian.analytics.client.configuration.AnalyticsConfig;
import com.atlassian.analytics.client.detect.OnDemandDetector;
import com.atlassian.analytics.client.sender.EventSender;
import com.atlassian.analytics.event.ProcessedEvent;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class AtomicEventSender
implements DisposableBean,
LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(AtomicEventSender.class);
    private final AnalyticsConfig analyticsConfig;
    private final OnDemandDetector onDemandDetector;
    private final AtomicReference<EventSender> sender = new AtomicReference();

    public AtomicEventSender(AnalyticsConfig analyticsConfig, OnDemandDetector onDemandDetector) {
        this.analyticsConfig = analyticsConfig;
        this.onDemandDetector = onDemandDetector;
    }

    public void onStart() {
        this.createSender();
    }

    private void createSender() {
        if (this.onDemandDetector.isOnDemand()) {
            this.sender.set(EventSender.newInstance(this.analyticsConfig));
        }
    }

    public void updateSender() {
        EventSender newSender = EventSender.newInstance(this.analyticsConfig);
        log.info("Setting new analytics destination: " + newSender);
        EventSender oldSender = this.sender.get();
        if (oldSender != null) {
            try {
                oldSender.destroy();
            }
            catch (Exception e) {
                log.error("Error destroying old event sender. Port may not have been closed properly: " + e.getMessage());
            }
        }
        this.sender.set(newSender);
    }

    public void sendIfValid(ProcessedEvent processedEvent) {
        if (this.isSenderValid()) {
            this.sender.get().send(processedEvent);
        }
    }

    private boolean isSenderValid() {
        return this.sender.get() != null;
    }

    public void destroy() {
        if (this.isSenderValid()) {
            ((EventSender)this.sender.getAndSet(null)).destroy();
        }
    }

    public void onStop() {
    }
}

