/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.hash.reader;

import com.atlassian.analytics.client.hash.reader.HashingInstructionsReader;
import com.atlassian.analytics.client.s3.AnalyticsS3Client;
import com.google.common.base.Optional;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteHashingInstructionsReader
implements HashingInstructionsReader {
    private static final Logger LOG = LoggerFactory.getLogger(RemoteHashingInstructionsReader.class);
    private static final String ANALYTICS_CONFIG_S3_BUCKET_NAME = "btf-analytics";
    private static final String ANALYTICS_CONFIG_S3_KEY_PREFIX = "config/";

    @Override
    public Optional<String> readInstructions(String instructionsKey) {
        block3: {
            try {
                Optional<InputStream> remoteListObject = this.getRemoteListObject(instructionsKey);
                if (remoteListObject.isPresent()) {
                    return Optional.fromNullable((Object)StringUtils.trim((String)IOUtils.toString((InputStream)((InputStream)remoteListObject.get()))));
                }
                LOG.warn("Unable to read remote instructions with key '{}'.", (Object)instructionsKey);
            }
            catch (IOException e) {
                LOG.warn("Unable to read remote instructions with key '{}'. Enable debug logging for more info.", (Object)instructionsKey);
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Unable to read remote instructions with key '{}'", (Object)instructionsKey, (Object)e);
            }
        }
        return Optional.absent();
    }

    private Optional<InputStream> getRemoteListObject(String objectName) {
        return Optional.fromNullable((Object)new AnalyticsS3Client().getS3ObjectInputStream(ANALYTICS_CONFIG_S3_BUCKET_NAME, ANALYTICS_CONFIG_S3_KEY_PREFIX + objectName));
    }
}

