/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.filter;

import com.atlassian.analytics.client.filter.AbstractHttpFilter;
import com.atlassian.analytics.client.sen.SenProvider;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class DefaultAnalyticsFilter
extends AbstractHttpFilter {
    private static final String X_SEN_HEADER = "X-ASEN";
    private final SenProvider senProvider;

    public DefaultAnalyticsFilter(SenProvider senProvider) {
        this.senProvider = senProvider;
    }

    @Override
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String sen = this.senProvider.getSen();
        if (StringUtils.isNotBlank((String)sen)) {
            response.setHeader(X_SEN_HEADER, sen);
            DefaultAnalyticsFilter.setB3TraceId(request);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

