/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.eventfilter.whitelist;

import com.atlassian.analytics.client.eventfilter.whitelist.FilteredEventAttributes;
import com.atlassian.analytics.client.eventfilter.whitelist.Whitelist;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AggregatedWhitelist {
    private volatile ImmutableList<Whitelist> externalWhitelists = ImmutableList.of();

    public static AggregatedWhitelist createEmptyAggregate() {
        return new AggregatedWhitelist();
    }

    public void initialiseFrom(List<Whitelist> externalWhitelists) {
        this.externalWhitelists = ImmutableList.copyOf(externalWhitelists);
    }

    public boolean isEventWhitelisted(String eventName) {
        for (Whitelist whitelist : this.externalWhitelists) {
            if (whitelist.getFilteredEventAttributes(eventName) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isAttributeValueInAllowedList(String eventName, String attributeName, String attributeValue) {
        for (Whitelist whitelist : this.externalWhitelists) {
            FilteredEventAttributes filteredEventAttributes = whitelist.getFilteredEventAttributes(eventName);
            if (filteredEventAttributes == null || !filteredEventAttributes.hasAllowedAttributeValue(attributeName, attributeValue)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldAttributeBeHashed(String eventName, String attributeName) {
        for (Whitelist whitelist : this.externalWhitelists) {
            FilteredEventAttributes filteredEventAttributes = whitelist.getFilteredEventAttributes(eventName);
            if (filteredEventAttributes == null || !filteredEventAttributes.hasHashedAttribute(attributeName)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldAttributeBeDictionaryFiltered(String eventName, String attributeName) {
        for (Whitelist whitelist : this.externalWhitelists) {
            FilteredEventAttributes filteredEventAttributes = whitelist.getFilteredEventAttributes(eventName);
            if (filteredEventAttributes == null || !filteredEventAttributes.hasDictionaryFilteredAttribute(attributeName)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldAttributeBeWhitelisted(String eventName, String attributeName) {
        for (Whitelist whitelist : this.externalWhitelists) {
            FilteredEventAttributes filteredEventAttributes = whitelist.getFilteredEventAttributes(eventName);
            if (filteredEventAttributes == null || !filteredEventAttributes.hasWhitelistedAttribute(attributeName)) continue;
            return true;
        }
        return false;
    }

    public List<Whitelist> getWhitelists() {
        return this.externalWhitelists;
    }

    public Collection<? extends Whitelist.WhitelistBean> toWhitelistBeans() {
        ArrayList<Whitelist.WhitelistBean> whitelistBeans = new ArrayList<Whitelist.WhitelistBean>(this.externalWhitelists.size());
        for (Whitelist externalWhitelist : this.externalWhitelists) {
            whitelistBeans.add(new Whitelist.WhitelistBean(externalWhitelist));
        }
        return whitelistBeans;
    }
}

