/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client.eventfilter.parser;

import com.atlassian.analytics.client.eventfilter.reader.FilterListReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleListParser {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleListParser.class);
    private final FilterListReader filterListReader;

    public SimpleListParser(FilterListReader filterListReader) {
        this.filterListReader = filterListReader;
    }

    public Set<String> readSimpleFilterList(String filterListName) {
        HashSet<String> filteredEvents = new HashSet<String>();
        InputStream listInputStream = this.filterListReader.readFilterList(filterListName);
        if (listInputStream != null) {
            LOG.debug("Reading filter list resource, {}", (Object)filterListName);
            BufferedReader br = new BufferedReader(new InputStreamReader(listInputStream));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    String eventName = line.trim();
                    if (eventName.startsWith("#") || !StringUtils.isNotBlank((String)eventName)) continue;
                    filteredEvents.add(eventName);
                }
            }
            catch (IOException e) {
                LOG.debug("Failed reading filter list resource, {}", (Object)filterListName);
            }
        } else {
            LOG.debug("Couldn't find filter list resource, {}", (Object)filterListName);
            return null;
        }
        return filteredEvents;
    }
}

