/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.analytics.client;

import com.atlassian.analytics.client.configuration.AnalyticsConfig;
import com.atlassian.analytics.client.eventfilter.BlacklistFilter;
import com.atlassian.analytics.client.eventfilter.whitelist.WhitelistFilter;
import com.atlassian.analytics.client.logger.EventAnonymizer;
import com.atlassian.analytics.event.AnalyticsEvent;
import com.atlassian.analytics.event.ProcessedEvent;
import com.atlassian.analytics.event.RawEvent;
import java.util.Map;

public class EventPreprocessor {
    private final AnalyticsConfig analyticsConfig;
    private final BlacklistFilter blacklistFilter;
    private final WhitelistFilter whitelistFilter;
    private final EventAnonymizer eventAnonymizer;

    public EventPreprocessor(AnalyticsConfig analyticsConfig, BlacklistFilter blacklistFilter, WhitelistFilter whitelistFilter, EventAnonymizer eventAnonymizer) {
        this.analyticsConfig = analyticsConfig;
        this.blacklistFilter = blacklistFilter;
        this.whitelistFilter = whitelistFilter;
        this.eventAnonymizer = eventAnonymizer;
    }

    public boolean canCollect(RawEvent event, boolean isOnDemand) {
        return this.analyticsConfig.canCollectAnalytics() && !this.blacklistFilter.isEventBlacklisted(event) && this.whitelistFilter.isEventWhitelisted(event, isOnDemand);
    }

    public ProcessedEvent preprocess(RawEvent event, boolean isOnDemand) {
        Map<String, Object> whitelistedProperties = this.whitelistFilter.applyWhitelistToEvent(event.getName(), event.getProperties(), isOnDemand);
        return new ProcessedEvent.Builder((AnalyticsEvent)event).server(this.anonymizeServer(event, isOnDemand)).user(this.anonymizeUser(event, isOnDemand)).sourceIP(this.anonymizeSourceIP(event, isOnDemand)).atlPath(this.anonymizeAtlPath(event, isOnDemand)).properties(whitelistedProperties).build();
    }

    private String anonymizeServer(RawEvent event, boolean isOnDemand) {
        return isOnDemand ? event.getServer() : this.eventAnonymizer.hash(event.getServer());
    }

    private String anonymizeUser(RawEvent event, boolean isOnDemand) {
        return isOnDemand ? event.getUser() : this.eventAnonymizer.hash(event.getUser());
    }

    private String anonymizeSourceIP(RawEvent event, boolean isOnDemand) {
        return isOnDemand ? event.getSourceIP() : this.eventAnonymizer.hash(event.getSourceIP());
    }

    private String anonymizeAtlPath(RawEvent event, boolean isOnDemand) {
        return isOnDemand ? event.getAtlPath() : this.eventAnonymizer.hash(event.getAtlPath());
    }
}

