package com.atlassian.analytics.client.report;


import java.util.Map;

public class EventReportItem
{
    private final String name;
    private final long time;
    private final String user;
    private final String requestCorrelationId;
    private final Map<String, Object> properties;
    private final boolean removed;

    public EventReportItem(final String name, final long time, final String user, final String requestCorrelationId,
                           final Map<String, Object> properties, final boolean removed)
    {
        this.name = name;
        this.time = time;
        this.user = user;
        this.requestCorrelationId = requestCorrelationId;
        this.properties = properties;
        this.removed = removed;
    }

    public String getName()
    {
        return name;
    }

    public long getTime()
    {
        return time;
    }

    public String getUser()
    {
        return user;
    }

    public String getRequestCorrelationId() { return requestCorrelationId; }

    public Map<String, Object> getProperties()
    {
        return properties;
    }

    public boolean isRemoved()
    {
        return removed;
    }
}
