package com.atlassian.analytics.client.eventfilter.reader;

import com.atlassian.analytics.client.s3.AnalyticsS3Client;

import java.io.InputStream;

/**
 * Reads an S3 remotely stored filter list.
 */
public class RemoteListReader implements FilterListReader
{
    private static final String ANALYTICS_CONFIG_S3_BUCKET_NAME = "btf-analytics";
    private static final String ANALYTICS_CONFIG_S3_KEY_PREFIX = "config/";

    public InputStream readFilterList(String listName)
    {
        return getRemoteListObject(listName);
    }

    private InputStream getRemoteListObject(final String listName)
    {
        return new AnalyticsS3Client().getS3ObjectInputStream(ANALYTICS_CONFIG_S3_BUCKET_NAME, ANALYTICS_CONFIG_S3_KEY_PREFIX + listName);
    }
}
