package com.atlassian.analytics.client.eventfilter.parser;

import com.atlassian.analytics.client.eventfilter.reader.FilterListReader;
import com.atlassian.analytics.client.eventfilter.whitelist.FilteredEventAttributes;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

/**
 * Parses a JSON format file and returns a map of the events and their corresponding filtered attributes.
 */
public class JsonListParser
{
    private static final Logger LOG = LoggerFactory.getLogger(JsonListParser.class);

    private final FilterListReader filterListReader;

    public JsonListParser(FilterListReader filterListReader)
    {
        this.filterListReader = filterListReader;
    }

    public Map<String, FilteredEventAttributes> readJsonFilterList(final String filterListName)
    {
        ObjectMapper mapper = new ObjectMapper();
        try
        {
            final InputStream listInputStream = filterListReader.readFilterList(filterListName);
            if (listInputStream != null)
            {
                return mapper.readValue(listInputStream, new TypeReference<Map<String, FilteredEventAttributes>>() {});
            }
        }
        catch (IOException e)
        {
            LOG.error("Couldn't read the JSON list " + filterListName + " with error message: " + e.getMessage());
        }
        return null;
    }
}
