package com.atlassian.analytics.api.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <p>Indicates that event is critical and should be processed immediately.</p>
 *
 * <p>Such type of events are usually used to track critical events, after which application is very unlikely to recover
 * (for example, cluster panic). Such events should not be placed into the queue, because application may shutdown
 * before event is served.</p>
 *
 * <p>Critical events are handled synchronously in the caller thread and should be used very carefully, as they may
 * dramatically slow down application performance.</p>
 *
 * <p>Critical events have to be only used for "application crashed" type of events in clustered applications.</p>
 *
 * @since v5.2.5
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE})
public @interface Critical {
}
