/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen.annotations.asm;

import com.atlassian.plugins.codegen.AsmUtil;
import com.atlassian.plugins.codegen.annotations.asm.AbstractAnnotationParser;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class CustomFieldTypeLocator
extends AbstractAnnotationParser {
    private static final String JIRA_FIELDS_PACKAGE = "com.atlassian.jira.issue.customfields.impl";
    private Map<String, String> fieldTypeRegistry;

    public CustomFieldTypeLocator(Map<String, String> fieldTypeRegistry) {
        this.fieldTypeRegistry = fieldTypeRegistry;
    }

    public void parse() throws Exception {
        this.parse(JIRA_FIELDS_PACKAGE, new FieldClassVisitor());
    }

    public void parse(String basePackage) throws Exception {
        this.parse(basePackage, new FieldClassVisitor());
    }

    public class FieldClassVisitor
    extends ClassVisitor {
        private String visitedClassname;
        private boolean isCustomFieldType;

        public FieldClassVisitor() {
            super(AsmUtil.asmOpCode());
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.visitedClassname = CustomFieldTypeLocator.normalize((String)name);
            String iface = "com/atlassian/jira/issue/customfields/CustomFieldType";
            this.isCustomFieldType = false;
            this.isCustomFieldType = ArrayUtils.contains((Object[])interfaces, (Object)iface);
            if (!this.isCustomFieldType) {
                this.isCustomFieldType = this.superHasInterface(superName, iface);
            }
            if (this.isCustomFieldType) {
                String simpleName = StringUtils.substringAfterLast((String)this.visitedClassname, (String)".");
                CustomFieldTypeLocator.this.fieldTypeRegistry.put(simpleName, this.visitedClassname);
            }
        }

        private boolean superHasInterface(String superName, String interfaceName) {
            boolean hasInterface = false;
            if (CustomFieldTypeLocator.normalize((String)superName).equals("java.lang.Object")) {
                return false;
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String path = superName.replace('.', '/');
            try (InputStream is = classLoader.getResourceAsStream(path + ".class");){
                ClassReader classReader;
                if (null != is && !(hasInterface = ArrayUtils.contains((Object[])(classReader = new ClassReader(is)).getInterfaces(), (Object)interfaceName))) {
                    hasInterface = this.superHasInterface(classReader.getSuperName(), interfaceName);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return hasInterface;
        }

        public AnnotationVisitor visitAnnotation(String annotationName, boolean isVisible) {
            return null;
        }

        public MethodVisitor visitMethod(int i, String s, String s1, String s2, String[] strings) {
            return null;
        }

        public FieldVisitor visitField(int i, String s, String s1, String s2, Object o) {
            return null;
        }
    }
}

