/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.codegen.prompter.jira;

import com.atlassian.maven.plugins.amps.codegen.annotations.ModuleCreatorClass;
import com.atlassian.maven.plugins.amps.codegen.prompter.common.AbstractResourcePrompter;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.modules.common.Label;
import com.atlassian.plugins.codegen.modules.common.Resource;
import com.atlassian.plugins.codegen.modules.jira.ReportModuleCreator;
import com.atlassian.plugins.codegen.modules.jira.ReportProperties;
import com.atlassian.plugins.codegen.util.ClassnameUtil;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;

@ModuleCreatorClass(value=ReportModuleCreator.class)
public class ReportPrompter
extends AbstractResourcePrompter<ReportProperties> {
    public ReportPrompter(Prompter prompter) {
        super(prompter);
    }

    @Override
    public ReportProperties promptForBasicProperties(PluginModuleLocation moduleLocation) throws PrompterException {
        String className = this.promptJavaClassname("Enter New Classname", "MyReport");
        String packageName = this.promptJavaPackagename("Enter Package Name", this.getDefaultBasePackage() + ".jira.reports");
        String fqClass = ClassnameUtil.fullyQualifiedName((String)packageName, (String)className);
        ReportProperties props = new ReportProperties(fqClass);
        ArrayList<Resource> resources = new ArrayList<Resource>(2);
        String templatePath = "/templates/reports/" + props.getModuleKey() + "/";
        Resource view = new Resource();
        view.setName("view");
        view.setType("velocity");
        view.setLocation(templatePath + "view.vm");
        resources.add(view);
        props.setResources(resources);
        this.addI18nResource(props);
        Label label = new Label(props.getModuleKey() + ".label", props.getModuleName());
        props.setLabel(label);
        return props;
    }

    @Override
    public void promptForAdvancedProperties(ReportProperties props, PluginModuleLocation moduleLocation) throws PrompterException {
        props.setResources(this.promptForResources());
        this.addI18nResource(props);
        Label label = props.getLabel();
        String labelKey = this.promptNotBlank("Enter Label Key", props.getLabel().getKey());
        String labelValue = this.promptNotBlank("Enter Label Value", props.getLabel().getValue());
        label.setKey(labelKey);
        label.setValue(labelValue);
        props.addI18nProperty(labelKey, labelValue);
        List<String> labelParamVals = this.promptForList("Add Label Param?", "Enter Param Value");
        if (!labelParamVals.isEmpty()) {
            for (String labelVal : labelParamVals) {
                label.addParam(labelVal);
            }
        }
    }

    @Override
    protected Resource promptForResource() throws PrompterException {
        Resource resource = new Resource();
        resource.setName(this.promptNotBlank("Enter Resource Name"));
        resource.setType("velocity");
        resource.setLocation(this.promptNotBlank("Enter Location (path to resource file)"));
        return resource;
    }

    protected void addI18nResource(ReportProperties props) {
        Resource resource = new Resource();
        resource.setName("i18n");
        resource.setLocation(props.getClassname());
        resource.setType("i18n");
        props.addResource(resource);
    }
}

