/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen;

import com.atlassian.plugins.codegen.AmpsSystemPropertyVariable;
import com.atlassian.plugins.codegen.AmpsVersionUpdate;
import com.atlassian.plugins.codegen.ArtifactDependency;
import com.atlassian.plugins.codegen.BundleInstruction;
import com.atlassian.plugins.codegen.MavenPlugin;
import com.atlassian.plugins.codegen.PluginArtifact;
import com.atlassian.plugins.codegen.PluginProjectChangeset;
import com.atlassian.plugins.codegen.ProjectRewriter;
import com.atlassian.plugins.codegen.VersionId;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class MavenProjectRewriter
implements ProjectRewriter {
    private static final int POM_INDENTATION = 4;
    private final File pomFile;
    private final Document document;
    private final Element root;
    private static final ImmutableSet<String> AMPS_PLUGIN_IDS = ImmutableSet.of((Object)"amps-maven-plugin", (Object)"bamboo-maven-plugin", (Object)"bitbucket-maven-plugin", (Object)"confluence-maven-plugin", (Object)"crowd-maven-plugin", (Object)"fecru-maven-plugin", (Object[])new String[]{"jira-maven-plugin", "refapp-maven-plugin"});

    public MavenProjectRewriter(File pom) throws DocumentException, IOException {
        this.pomFile = (File)Preconditions.checkNotNull((Object)pom, (Object)"pom");
        this.document = this.readPom(pom);
        this.root = this.document.getRootElement();
    }

    public void applyChanges(PluginProjectChangeset changes) throws Exception {
        boolean modifyPom = false;
        modifyPom |= this.applyDependencyChanges(changes.getItems(ArtifactDependency.class));
        modifyPom |= this.applyMavenPluginChanges(changes.getItems(MavenPlugin.class));
        modifyPom |= this.applyBundleInstructionChanges(changes.getItems(BundleInstruction.class));
        modifyPom |= this.applyPluginArtifactChanges(changes.getItems(PluginArtifact.class));
        modifyPom |= this.applyAmpsSystemPropertyChanges(changes.getItems(AmpsSystemPropertyVariable.class));
        if (modifyPom |= this.applyAmpsVersionUpdate(changes.getItems(AmpsVersionUpdate.class))) {
            this.writePom(this.document, this.pomFile);
        }
    }

    private boolean applyDependencyChanges(Iterable<ArtifactDependency> dependencies) {
        boolean modified = false;
        Element eDependencies = MavenProjectRewriter.getOrCreateElement(this.root, "dependencies");
        for (ArtifactDependency descriptor : dependencies) {
            boolean alreadyExists = Iterables.any((Iterable)eDependencies.elements("dependency"), (Predicate)Predicates.and(MavenProjectRewriter.childElementValue("groupId", descriptor.getGroupAndArtifactId().getGroupId().orElse("")), MavenProjectRewriter.childElementValue("artifactId", descriptor.getGroupAndArtifactId().getArtifactId())));
            if (alreadyExists) continue;
            modified = true;
            Element eNewDep = eDependencies.addElement("dependency");
            eNewDep.addElement("groupId").setText((String)descriptor.getGroupAndArtifactId().getGroupId().get());
            eNewDep.addElement("artifactId").setText(descriptor.getGroupAndArtifactId().getArtifactId());
            eNewDep.addElement("version").setText((String)descriptor.getVersionId().getVersionOrPropertyPlaceholder().get());
            this.createVersionPropertyIfNecessary(descriptor.getVersionId());
            eNewDep.addElement("scope").setText(descriptor.getScope().name().toLowerCase());
        }
        return modified;
    }

    private void createVersionPropertyIfNecessary(VersionId versionId) {
        versionId.getPropertyName().ifPresent(p -> {
            Element eProperties = MavenProjectRewriter.getOrCreateElement(this.root, "properties");
            if (eProperties.element(p) == null) {
                eProperties.addElement(p).setText(versionId.getVersion().orElse(""));
            }
        });
    }

    private boolean applyMavenPluginChanges(Iterable<MavenPlugin> mavenPlugins) throws Exception {
        boolean modified = false;
        Element ePlugins = MavenProjectRewriter.getOrCreateElement(this.root, "build/plugins");
        for (MavenPlugin descriptor : mavenPlugins) {
            Document fragDoc = DocumentHelper.parseText((String)("<root>" + descriptor.getXmlContent() + "</root>"));
            Optional groupId = descriptor.getGroupAndArtifactId().getGroupId();
            String artifactId = descriptor.getGroupAndArtifactId().getArtifactId();
            Predicate matchGroup = groupId.isPresent() ? MavenProjectRewriter.childElementValue("groupId", (String)groupId.get()) : Predicates.or(MavenProjectRewriter.childElementValue("groupId", ""), MavenProjectRewriter.childElementValue("groupId", "org.apache.maven.plugins"));
            Predicate match = Predicates.and((Predicate)matchGroup, MavenProjectRewriter.childElementValue("artifactId", artifactId));
            if (Iterables.any((Iterable)ePlugins.elements("plugin"), (Predicate)match)) {
                modified |= this.mergeMavenPluginConfig((Element)Iterables.find((Iterable)ePlugins.elements("plugin"), (Predicate)match), fragDoc.getRootElement());
                continue;
            }
            ePlugins.add(this.toMavenPluginElement(descriptor, fragDoc.getRootElement()));
            modified = true;
        }
        return modified;
    }

    private boolean applyAmpsVersionUpdate(Iterable<AmpsVersionUpdate> items) {
        boolean modified = false;
        DefaultArtifactVersion newAmpsVersion = new DefaultArtifactVersion("0.0");
        for (AmpsVersionUpdate changeItem : items) {
            DefaultArtifactVersion changeVersion = new DefaultArtifactVersion(changeItem.getVersion());
            if (changeVersion.compareTo((ArtifactVersion)newAmpsVersion) > 0) {
                newAmpsVersion = changeVersion;
            }
            if ("plugin".equalsIgnoreCase(changeItem.getType()) && changeItem.isApplyConfig()) {
                modified = this.applyAmpsPluginVersionUpdate();
            }
            if ("management".equalsIgnoreCase(changeItem.getType()) && changeItem.isApplyConfig()) {
                boolean managementUpdated = this.applyAmpsPluginManagementVersionUpdate();
                if (!modified) {
                    modified = managementUpdated;
                }
            }
            if (!changeItem.isApplyProp()) continue;
            Element ampsVersionProperty = MavenProjectRewriter.getOrCreateElement(MavenProjectRewriter.getOrCreateElement(this.root, "properties"), "amps.version");
            if (StringUtils.isNotBlank((CharSequence)ampsVersionProperty.getTextTrim())) {
                DefaultArtifactVersion pomVersion = new DefaultArtifactVersion(ampsVersionProperty.getTextTrim());
                if (newAmpsVersion.compareTo((ArtifactVersion)pomVersion) <= 0) continue;
                modified = true;
                ampsVersionProperty.setText(newAmpsVersion.toString());
                continue;
            }
            ampsVersionProperty.setText(newAmpsVersion.toString());
            modified = true;
        }
        return modified;
    }

    private boolean applyAmpsPluginVersionUpdate() {
        boolean modified = false;
        Element ampsVersionElement = MavenProjectRewriter.getOrCreateElement(this.findAmpsPlugin(), "version");
        if (!"${amps.version}".equals(ampsVersionElement.getTextTrim())) {
            ampsVersionElement.setText("${amps.version}");
            modified = true;
        }
        return modified;
    }

    private boolean applyAmpsPluginManagementVersionUpdate() {
        Element ampsVersionElement;
        boolean modified = false;
        Element ampsManagementPlugin = this.findAmpsPluginManagement();
        if (null != ampsManagementPlugin && !"${amps.version}".equals((ampsVersionElement = MavenProjectRewriter.getOrCreateElement(ampsManagementPlugin, "version")).getTextTrim())) {
            ampsVersionElement.setText("${amps.version}");
            modified = true;
        }
        return modified;
    }

    public String getAmpsVersionInPom() {
        Element ampsVersion = MavenProjectRewriter.getElementOrNull(this.findAmpsPlugin(), "version");
        if (null != ampsVersion) {
            return ampsVersion.getTextTrim();
        }
        return "";
    }

    public boolean definesProperty(String propName) {
        Element properties = MavenProjectRewriter.getElementOrNull(this.root, "properties");
        if (null != properties) {
            return null != MavenProjectRewriter.getElementOrNull(properties, propName);
        }
        return false;
    }

    public String getAmpsPluginManagementVersionInPom() {
        Element ampsVersion;
        Element ampsManagementPlugin = this.findAmpsPluginManagement();
        String version = "";
        if (null != ampsManagementPlugin && null != (ampsVersion = MavenProjectRewriter.getElementOrNull(ampsManagementPlugin, "version"))) {
            version = ampsVersion.getTextTrim();
        }
        return version;
    }

    private boolean mergeMavenPluginConfig(Element ePlugin, Element paramsDesc) {
        boolean modified = false;
        Element eExecutions = MavenProjectRewriter.getOrCreateElement(ePlugin, "executions");
        for (Object node : paramsDesc.selectNodes("executions/execution")) {
            Element eExecution = (Element)node;
            String id = eExecution.elementTextTrim("id");
            if (Iterables.any((Iterable)eExecutions.elements("execution"), MavenProjectRewriter.childElementValue("id", id))) continue;
            this.detachAndAdd(eExecution, eExecutions);
            modified = true;
        }
        return modified;
    }

    private Element toMavenPluginElement(MavenPlugin descriptor, Element paramsDesc) {
        Element p = this.createElement("plugin");
        descriptor.getGroupAndArtifactId().getGroupId().ifPresent(groupId -> p.addElement("groupId").setText(groupId));
        p.addElement("artifactId").setText(descriptor.getGroupAndArtifactId().getArtifactId());
        if (descriptor.getVersionId().isDefined()) {
            p.addElement("version").setText((String)descriptor.getVersionId().getVersionOrPropertyPlaceholder().get());
            this.createVersionPropertyIfNecessary(descriptor.getVersionId());
        }
        if ("true".equals(paramsDesc.elementText("extensions"))) {
            p.addElement("extensions").setText("true");
        }
        for (Element oParam : paramsDesc.elements()) {
            this.detachAndAdd(oParam, p);
        }
        return p;
    }

    private boolean applyBundleInstructionChanges(Iterable<BundleInstruction> instructions) {
        if (!instructions.iterator().hasNext()) {
            return false;
        }
        Element configRoot = this.getAmpsPluginConfiguration();
        boolean modified = false;
        Element instructionsRoot = MavenProjectRewriter.getOrCreateElement(configRoot, "instructions");
        for (BundleInstruction instruction : instructions) {
            Object[] instructionLines;
            String categoryName = instruction.getCategory().getElementName();
            Element categoryElement = MavenProjectRewriter.getOrCreateElement(instructionsRoot, categoryName);
            String body = categoryElement.getText();
            Object[] objectArray = instructionLines = body == null ? new String[]{} : body.split(",");
            if (Iterables.any((Iterable)ImmutableList.copyOf((Object[])instructionLines), MavenProjectRewriter.bundleInstructionLineWithPackageName(instruction.getPackageName()))) continue;
            categoryElement.setText(MavenProjectRewriter.addInstructionLine((String[])instructionLines, instruction));
            modified = true;
        }
        return modified;
    }

    private static String addInstructionLine(String[] instructionLines, BundleInstruction instruction) {
        String newLine = MavenProjectRewriter.getNewLine(instruction);
        if (instructionLines.length == 0 || instructionLines[0].trim().isEmpty()) {
            return newLine;
        }
        StringBuilder buf = new StringBuilder();
        boolean inserted = false;
        String indent = "";
        Pattern indentRegex = Pattern.compile("^\\n*([ \\t]*).*");
        for (String oldLine : instructionLines) {
            Matcher m;
            if (buf.length() > 0) {
                buf.append(",");
            }
            if (!inserted && oldLine.trim().compareTo(newLine) > 0) {
                buf.append("\n").append(indent).append(newLine).append(",\n");
                inserted = true;
            }
            if (indent.isEmpty() && (m = indentRegex.matcher(oldLine)).matches()) {
                indent = m.group(1);
            }
            buf.append(oldLine);
        }
        if (!inserted) {
            buf.append(",\n").append(newLine);
        }
        return buf.toString();
    }

    private static String getNewLine(BundleInstruction instruction) {
        return instruction.getVersion().map(version -> instruction.getPackageName() + ";version=\"" + version + "\"").orElse(instruction.getPackageName());
    }

    private boolean applyPluginArtifactChanges(Iterable<PluginArtifact> pluginArtifacts) {
        if (!pluginArtifacts.iterator().hasNext()) {
            return false;
        }
        Element configRoot = this.getAmpsPluginConfiguration();
        boolean modified = false;
        for (PluginArtifact p : pluginArtifacts) {
            String elementName = p.getType().getElementName();
            Element artifactsRoot = MavenProjectRewriter.getOrCreateElement(configRoot, elementName + "s");
            if (Iterables.any((Iterable)artifactsRoot.elements(elementName), (Predicate)Predicates.and(MavenProjectRewriter.childElementValue("groupId", p.getGroupAndArtifactId().getGroupId().orElse("")), MavenProjectRewriter.childElementValue("artifactId", p.getGroupAndArtifactId().getArtifactId())))) continue;
            artifactsRoot.add(this.toArtifactElement(p));
            modified = true;
        }
        return modified;
    }

    private boolean applyAmpsSystemPropertyChanges(Iterable<AmpsSystemPropertyVariable> propertyVariables) {
        if (!propertyVariables.iterator().hasNext()) {
            return false;
        }
        Element configRoot = this.getAmpsPluginConfiguration();
        boolean modified = false;
        for (AmpsSystemPropertyVariable propertyVariable : propertyVariables) {
            Element variablesRoot = MavenProjectRewriter.getOrCreateElement(configRoot, "systemPropertyVariables");
            if (variablesRoot.element(propertyVariable.getName()) != null) continue;
            variablesRoot.addElement(propertyVariable.getName()).setText(propertyVariable.getValue());
            modified = true;
        }
        return modified;
    }

    private Element toArtifactElement(PluginArtifact pluginArtifact) {
        Element ret = this.createElement(pluginArtifact.getType().getElementName());
        pluginArtifact.getGroupAndArtifactId().getGroupId().ifPresent(groupId -> ret.addElement("groupId").setText(groupId));
        ret.addElement("artifactId").setText(pluginArtifact.getGroupAndArtifactId().getArtifactId());
        if (pluginArtifact.getVersionId().isDefined()) {
            ret.addElement("version").setText((String)pluginArtifact.getVersionId().getVersionOrPropertyPlaceholder().get());
            this.createVersionPropertyIfNecessary(pluginArtifact.getVersionId());
        }
        return ret;
    }

    private Element findAmpsPlugin() {
        Element plugins = MavenProjectRewriter.getElementOrNull(this.root, "build/plugins");
        if (null != plugins) {
            for (Element p : plugins.elements("plugin")) {
                if (!"com.atlassian.maven.plugins".equals(p.elementTextTrim("groupId")) || !AMPS_PLUGIN_IDS.contains((Object)p.elementTextTrim("artifactId"))) continue;
                return p;
            }
        }
        throw new IllegalStateException("Could not find AMPS plugin element in POM");
    }

    private Element findAmpsPluginManagement() {
        Element plugins = MavenProjectRewriter.getElementOrNull(this.root, "build/pluginManagement/plugins");
        if (null != plugins) {
            for (Element p : plugins.elements("plugin")) {
                if (!"com.atlassian.maven.plugins".equals(p.elementTextTrim("groupId")) || !AMPS_PLUGIN_IDS.contains((Object)p.elementTextTrim("artifactId"))) continue;
                return p;
            }
        }
        return null;
    }

    private Element getAmpsPluginConfiguration() {
        return MavenProjectRewriter.getOrCreateElement(this.findAmpsPlugin(), "configuration");
    }

    private static Element getOrCreateElement(Element container, String path) {
        Element last = container;
        for (String pathName : path.split("/")) {
            last = container.element(pathName);
            if (last == null) {
                last = container.addElement(pathName);
            }
            container = last;
        }
        return last;
    }

    private static Element getElementOrNull(Element container, String path) {
        for (String pathName : path.split("/")) {
            if (container == null) continue;
            container = container.element(pathName);
        }
        return container;
    }

    private Document readPom(File f) throws DocumentException, IOException {
        SAXReader reader = new SAXReader();
        reader.setMergeAdjacentText(true);
        reader.setStripWhitespaceText(true);
        return reader.read((InputStream)new FileInputStream(f));
    }

    private void writePom(Document doc, File f) throws IOException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setIndentSize(4);
        try (FileOutputStream fos = new FileOutputStream(f);){
            XMLWriter writer = new XMLWriter((OutputStream)fos, format);
            writer.write(doc);
        }
    }

    private Element createElement(String name) {
        return DocumentHelper.createElement((QName)new QName(name, this.root.getNamespace()));
    }

    private void fixNamespace(Element e) {
        e.setQName(new QName(e.getName(), this.root.getNamespace()));
        for (Element child : e.elements()) {
            this.fixNamespace(child);
        }
    }

    private void detachAndAdd(Element e, Element container) {
        e.detach();
        this.fixNamespace(e);
        container.add(e);
    }

    private static Predicate<Element> childElementValue(String name, String value) {
        return input -> {
            Element child = input.element(name);
            return child == null ? value.isEmpty() : value.equals(child.getText());
        };
    }

    private static Predicate<String> bundleInstructionLineWithPackageName(String packageName) {
        return input -> {
            String s = input.trim();
            return s.equals(packageName) || s.startsWith(packageName + ";");
        };
    }
}

