/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules.common.keyboard;

import com.atlassian.plugins.codegen.modules.BasicNameModuleProperties;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;

public abstract class AbstractKeyboardShortcutProperties
extends BasicNameModuleProperties {
    public static final String HIDDEN = "HIDDEN";
    public static final String ORDER = "ORDER";
    public static final String SHORTCUT = "SHORTCUT";
    public static final String OPERATION_TYPE = "OPERATION_TYPE";
    public static final String OPERATION_VALUE = "OPERATION_VALUE";
    public static final String CONTEXT = "CONTEXT";
    public static final List<String> OPERATIONS = Lists.newArrayList((Object[])new String[]{"click", "evaluate", "execute", "followLink", "goTo", "moveToAndClick", "moveToAndFocus", "moveToNextItem", "moveToPrevItem"});
    private static final List<String> XPRODUCT_CONTEXTS = Lists.newArrayList((Object[])new String[]{"global"});
    private final List<String> allowedContexts;

    public AbstractKeyboardShortcutProperties() {
        this("My Keyboard Shortcut");
    }

    public AbstractKeyboardShortcutProperties(String moduleName) {
        super(moduleName);
        this.setHidden(false);
        this.setOrder(10);
        this.setContext("global");
        this.allowedContexts = ImmutableList.copyOf((Iterable)Iterables.concat(XPRODUCT_CONTEXTS, this.getAdditionalContexts()));
    }

    public List<String> getAllowedContexts() {
        return this.allowedContexts;
    }

    public void setHidden(boolean hidden) {
        this.setProperty(HIDDEN, Boolean.toString(hidden));
    }

    public boolean isHidden() {
        return Boolean.valueOf(this.getProperty(HIDDEN));
    }

    public void setOrder(int order) {
        this.setProperty(ORDER, Integer.toString(order));
    }

    public String getOrder() {
        return this.getProperty(ORDER);
    }

    public int getOrderAsInt() {
        return Integer.parseInt(this.getProperty(ORDER));
    }

    public void setShortcut(String s) {
        this.setProperty(SHORTCUT, s);
    }

    public String getShortcut() {
        return this.getProperty(SHORTCUT);
    }

    public void setContext(String s) {
        this.setProperty(CONTEXT, s);
    }

    public String getContext() {
        return this.getProperty(CONTEXT);
    }

    public void setOperationType(String s) {
        this.setProperty(OPERATION_TYPE, s);
    }

    public String getOperationType() {
        return this.getProperty(OPERATION_TYPE);
    }

    public void setOperationValue(String s) {
        this.setProperty(OPERATION_VALUE, s);
    }

    public String getOperationValue() {
        return this.getProperty(OPERATION_VALUE);
    }

    protected List<String> getAdditionalContexts() {
        return Collections.emptyList();
    }
}

