/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules.common;

import com.atlassian.plugins.codegen.annotations.ConfluencePluginModuleCreator;
import com.atlassian.plugins.codegen.annotations.Dependencies;
import com.atlassian.plugins.codegen.annotations.Dependency;
import com.atlassian.plugins.codegen.annotations.FeCruPluginModuleCreator;
import com.atlassian.plugins.codegen.annotations.JiraPluginModuleCreator;
import com.atlassian.plugins.codegen.annotations.RefAppPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.AbstractPluginModuleCreator;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import com.atlassian.plugins.codegen.modules.common.GadgetProperties;
import java.io.File;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

@RefAppPluginModuleCreator
@JiraPluginModuleCreator
@ConfluencePluginModuleCreator
@FeCruPluginModuleCreator
@Dependencies(value={@Dependency(groupId="org.mockito", artifactId="mockito-all", version="1.8.5", scope="test")})
public class GadgetModuleCreator
extends AbstractPluginModuleCreator<GadgetProperties> {
    public static final String MODULE_NAME = "Gadget Plugin Module";
    private static final String TEMPLATE_PREFIX = "templates/common/gadget/";
    private static final String GADGET_TEMPLATE = "templates/common/gadget/gadget.xml.vtl";
    private static final String PLUGIN_MODULE_TEMPLATE = "templates/common/gadget/gadget-plugin.xml.vtl";

    @Override
    public void createModule(PluginModuleLocation location, GadgetProperties props) throws Exception {
        if (!props.includeExamples()) {
            String gadgetLocation = props.getLocation();
            String gadgetFilename = FilenameUtils.getName((String)gadgetLocation);
            String gadgetPath = FilenameUtils.getPath((String)gadgetLocation);
            File gadgetFolder = StringUtils.isNotBlank((String)gadgetPath) ? new File(location.getResourcesDir(), gadgetPath) : location.getResourcesDir();
            this.templateHelper.writeFileFromTemplate(GADGET_TEMPLATE, gadgetFilename, gadgetFolder, props);
        }
        this.addModuleToPluginXml(PLUGIN_MODULE_TEMPLATE, location, props);
    }

    public String getModuleName() {
        return MODULE_NAME;
    }
}

