/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import org.apache.commons.lang.Validate;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class PluginXmlHelper {
    private final File pluginXml;
    private final Document document;

    public PluginXmlHelper(File pluginXml) throws Exception {
        Validate.notNull((Object)pluginXml);
        Validate.isTrue((boolean)pluginXml.exists());
        this.pluginXml = pluginXml;
        FileInputStream is = new FileInputStream(pluginXml);
        this.document = this.createDocument(is);
    }

    public void addModuleAsLastChild(String fragment) throws Exception {
        try {
            Document fragDoc = DocumentHelper.parseText((String)fragment);
            Element pluginRoot = this.document.getRootElement();
            pluginRoot.add(fragDoc.getRootElement());
        }
        catch (DocumentException e) {
            throw new Exception("Could not parse module XML fragment", e);
        }
    }

    public void addI18nResource(String name) throws Exception {
        String xpath = "//resource[@type='i18n' and @location='" + name + "']";
        Node resourceNode = this.document.selectSingleNode(xpath);
        if (null == resourceNode) {
            Element pluginRoot = this.document.getRootElement();
            Document fragDoc = DocumentHelper.parseText((String)("<resource type=\"i18n\" name=\"i18n\" location=\"" + name + "\" />"));
            pluginRoot.add(fragDoc.getRootElement());
        }
    }

    public void addPluginInfoParam(String name, String value) throws Exception {
        Element pluginInfo = (Element)this.document.selectSingleNode("//plugin-info");
        if (pluginInfo == null) {
            pluginInfo = this.document.addElement("plugin-info");
        }
        pluginInfo.addElement("param").addAttribute("name", name).setText(value);
    }

    public String getPluginXmlAsString() {
        return this.document.asXML();
    }

    protected Document getDocument() {
        return this.document;
    }

    protected Document createDocument(InputStream source) throws Exception {
        SAXReader reader = new SAXReader();
        reader.setMergeAdjacentText(true);
        reader.setStripWhitespaceText(false);
        try {
            return reader.read(source);
        }
        catch (DocumentException e) {
            throw new Exception("Cannot parse XML plugin descriptor", e);
        }
    }

    public void savePluginXml() throws IOException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        XMLWriter writer = new XMLWriter((Writer)new FileWriter(this.pluginXml), format);
        writer.write(this.document);
        writer.close();
    }
}

