/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.modules.common.web;

import com.atlassian.plugins.codegen.modules.common.Resource;
import com.atlassian.plugins.codegen.modules.common.web.AbstractConditionsProperties;
import com.atlassian.plugins.codegen.modules.common.web.WebResourceTransformation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class WebResourceProperties
extends AbstractConditionsProperties {
    public static final String RESOURCES = "RESOURCES";
    public static final String DEPENDENCIES = "DEPENDENCIES";
    public static final String CONTEXTS = "CONTEXTS";
    public static final String TRANSFORMATIONS = "TRANSFORMATIONS";
    public static final List<String> KNOWN_CONTEXTS = WebResourceProperties.initContexts();

    private static List<String> initContexts() {
        ArrayList<String> contexts = new ArrayList<String>(3);
        contexts.add("atl.general");
        contexts.add("atl.admin");
        contexts.add("atl.userprofile");
        return Collections.unmodifiableList(contexts);
    }

    public WebResourceProperties() {
        this("My Web Resource");
    }

    public WebResourceProperties(String moduleName) {
        super(moduleName);
        this.setDependencies(new ArrayList<String>());
        this.setContexts(new ArrayList<String>());
        this.setTransformations(new ArrayList<WebResourceTransformation>());
        this.setResources(new ArrayList<Resource>());
    }

    public void setResources(List<Resource> resources) {
        this.put(RESOURCES, resources);
    }

    public List<Resource> getResources() {
        return (List)this.get(RESOURCES);
    }

    public void setDependencies(List<String> dependencies) {
        this.put(DEPENDENCIES, dependencies);
    }

    public List<String> getDependencies() {
        return (List)this.get(DEPENDENCIES);
    }

    public void addDependency(String dependency) {
        ArrayList<String> dependencies = (ArrayList<String>)this.get(DEPENDENCIES);
        if (dependencies == null) {
            dependencies = new ArrayList<String>();
            this.setDependencies(dependencies);
        }
        dependencies.add(dependency);
    }

    public void setContexts(List<String> contexts) {
        this.put(CONTEXTS, contexts);
    }

    public List<String> getContexts() {
        return (List)this.get(CONTEXTS);
    }

    public void addContext(String context) {
        ArrayList<String> contexts = (ArrayList<String>)this.get(CONTEXTS);
        if (contexts == null) {
            contexts = new ArrayList<String>();
            this.setContexts(contexts);
        }
        contexts.add(context);
    }

    public void setTransformations(List<WebResourceTransformation> transformations) {
        this.put(TRANSFORMATIONS, transformations);
    }

    public List<WebResourceTransformation> getTransformations() {
        return (List)this.get(TRANSFORMATIONS);
    }

    public void addTransformation(WebResourceTransformation transformation) {
        ArrayList<WebResourceTransformation> transformations = (ArrayList<WebResourceTransformation>)this.get(TRANSFORMATIONS);
        if (transformations == null) {
            transformations = new ArrayList<WebResourceTransformation>();
            this.setTransformations(transformations);
        }
        transformations.add(transformation);
    }

    public List<String> knownContexts() {
        return KNOWN_CONTEXTS;
    }
}

