/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.codegen.util;

import com.atlassian.fugue.Option;
import com.atlassian.plugins.codegen.modules.PluginModuleLocation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class PluginXmlHelper {
    private final File xmlFile;
    private final Document document;
    private final PluginModuleLocation location;

    public PluginXmlHelper(PluginModuleLocation location) throws IOException, DocumentException {
        this(location, "atlassian-plugin.xml");
    }

    public PluginXmlHelper(PluginModuleLocation location, String fileName) throws IOException, DocumentException {
        this.location = location;
        this.xmlFile = new File(location.getResourcesDir(), fileName);
        SAXReader reader = new SAXReader();
        reader.setMergeAdjacentText(true);
        reader.setStripWhitespaceText(false);
        this.document = reader.read((InputStream)new FileInputStream(this.xmlFile));
    }

    public Document getDocument() {
        return this.document;
    }

    public File getXmlFile() {
        return this.xmlFile;
    }

    public String getPluginKey() {
        String key = this.document.getRootElement().attributeValue("key");
        if (key == null) {
            throw new IllegalStateException("atlassian-plugin element does not have required attribute: key");
        }
        return key.replace("${project.groupId}", this.location.getGroupId()).replace("${project.artifactId}", this.location.getArtifactId());
    }

    public String getDefaultI18nName() {
        return "i18n";
    }

    public String getDefaultI18nLocation() {
        List i18nElements = this.document.selectNodes("//resource[@type='i18n']");
        if (!i18nElements.isEmpty()) {
            return ((Element)i18nElements.get(0)).attributeValue("location");
        }
        return this.getPluginKey();
    }

    public static Option<Element> findElementByTypeAndAttribute(Element parent, String type, String attributeName, String attributeValue) {
        for (Element e : parent.elements(type)) {
            if (!attributeValue.equals(e.attributeValue(attributeName))) continue;
            return Option.some((Object)e);
        }
        return Option.none();
    }
}

